/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.spi;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface PropertySource {
    public static final String TAMAYA_ORDINAL = "tamaya.ordinal";

    default public int getOrdinal() {
        String configuredOrdinal = this.get(TAMAYA_ORDINAL);
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e, () -> "Configured Ordinal is not an int number: " + configuredOrdinal);
            }
        }
        return this.getDefaultOrdinal();
    }

    default public int getDefaultOrdinal() {
        return 0;
    }

    public String getName();

    default public String get(String key) {
        Objects.requireNonNull(key, "key must not be null");
        return this.getProperties().get(key);
    }

    public Map<String, String> getProperties();

    default public boolean isScannable() {
        return true;
    }
}

