/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.TypeLiteral;

public interface Configuration {
    default public String get(String key) {
        return this.getProperties().get(key);
    }

    default public <T> T get(String key, Class<T> type) {
        return (T)this.get(key, TypeLiteral.of(type));
    }

    public <T> T get(String var1, TypeLiteral<T> var2);

    default public Optional<String> getOptional(String key) {
        return Optional.ofNullable(this.get(key));
    }

    default public <T> Optional<T> getOptional(String key, Class<T> type) {
        return Optional.ofNullable(this.get(key, type));
    }

    default public <T> Optional<T> getOptional(String key, TypeLiteral<T> type) {
        return Optional.ofNullable(this.get(key, type));
    }

    public Map<String, String> getProperties();

    default public Optional<Boolean> getBoolean(String key) {
        return this.getOptional(key, Boolean.class);
    }

    default public OptionalInt getInteger(String key) {
        Optional<Integer> val = this.getOptional(key, Integer.class);
        if (val.isPresent()) {
            return OptionalInt.of(val.get());
        }
        return OptionalInt.empty();
    }

    default public OptionalLong getLong(String key) {
        Optional<Long> val = this.getOptional(key, Long.class);
        if (val.isPresent()) {
            return OptionalLong.of(val.get());
        }
        return OptionalLong.empty();
    }

    default public OptionalDouble getDouble(String key) {
        Optional<Double> val = this.getOptional(key, Double.class);
        if (val.isPresent()) {
            return OptionalDouble.of(val.get());
        }
        return OptionalDouble.empty();
    }

    default public Configuration with(ConfigOperator operator) {
        return operator.operate(this);
    }

    default public <T> T query(ConfigQuery<T> query) {
        return query.query(this);
    }
}

