/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.folderobserver;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.events.folderobserver.FileChangeObserver;

class FileChangeListener
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(FileChangeListener.class.getName());
    private WatchService watchService;
    private FileChangeObserver observer;
    private Path directory;
    private volatile boolean running = true;

    public FileChangeListener(Path directory, FileChangeObserver observer) {
        this.observer = observer;
        this.directory = directory;
        this.watchService = this.getWatchService();
        if (Objects.nonNull(this.watchService) && Objects.nonNull(directory)) {
            try {
                directory.register(this.watchService, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            }
            catch (IOException e) {
                throw new FileChangeListenerException("An error happened when does try to registry to watch the folder", e);
            }
        }
    }

    public void stopListener() {
        this.running = false;
    }

    @Override
    public void run() {
        if (Objects.isNull(this.watchService) || Objects.isNull(this.directory)) {
            return;
        }
        while (this.running) {
            this.watchFolder();
        }
    }

    private void watchFolder() {
        try {
            WatchKey watckKey = this.watchService.take();
            for (WatchEvent<?> event : watckKey.pollEvents()) {
                Path filePath = (Path)watckKey.watchable();
                if (!event.kind().equals(StandardWatchEventKinds.ENTRY_CREATE) && !event.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY) && !event.kind().equals(StandardWatchEventKinds.ENTRY_DELETE)) continue;
                LOGGER.info("File change detected in: " + filePath.getFileName());
                this.observer.directoryChanged(filePath);
            }
            watckKey.reset();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            throw new FileChangeListenerException("An error happened when does try to watch the folder", e);
        }
    }

    private WatchService getWatchService() {
        try {
            FileSystem fileSystem = Paths.get(".", new String[0]).getFileSystem();
            return fileSystem.newWatchService();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "The file System does not supports WatchService", e);
            return null;
        }
    }

    static class FileChangeListenerException
    extends ConfigException {
        private static final long serialVersionUID = -8965486770881001513L;

        public FileChangeListenerException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

