/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.delta;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.events.FrozenConfiguration;
import org.apache.tamaya.events.delta.ConfigurationChangeBuilder;

public final class ConfigurationChange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FrozenConfiguration configuration;
    private String version = UUID.randomUUID().toString();
    private long timestamp = System.currentTimeMillis();
    private Map<String, PropertyChangeEvent> changes = new HashMap<String, PropertyChangeEvent>();

    public static ConfigurationChange emptyChangeSet(Configuration configuration) {
        return ConfigurationChangeBuilder.of(configuration).build();
    }

    ConfigurationChange(ConfigurationChangeBuilder builder) {
        this.configuration = FrozenConfiguration.of(builder.source);
        for (PropertyChangeEvent ev : builder.delta.values()) {
            this.changes.put(ev.getPropertyName(), ev);
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Collection<PropertyChangeEvent> getEvents() {
        return Collections.unmodifiableCollection(this.changes.values());
    }

    public int getRemovedSize() {
        int removedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getNewValue() != null) continue;
            ++removedCount;
        }
        return removedCount;
    }

    public int getAddedSize() {
        int addedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getOldValue() != null || ev.getNewValue() == null) continue;
            ++addedCount;
        }
        return addedCount;
    }

    public int getUpdatedSize() {
        int updatedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getOldValue() == null || ev.getNewValue() == null) continue;
            ++updatedCount;
        }
        return updatedCount;
    }

    public boolean isRemoved(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getNewValue() == null;
    }

    public boolean isAdded(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getOldValue() == null;
    }

    public boolean isUpdated(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getOldValue() != null && change.getNewValue() != null;
    }

    public boolean containsKey(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getNewValue() != null;
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public String toString() {
        return "ConfigurationChange{configuration=" + this.configuration + ", version='" + this.version + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

