/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events;

import org.apache.tamaya.ConfigException;
import org.apache.tamaya.events.ConfigEventListener;
import org.apache.tamaya.events.spi.ConfigEventSpi;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ConfigEvent {
    private static final ConfigEventSpi SPI = (ConfigEventSpi)ServiceContextManager.getServiceContext().getService(ConfigEventSpi.class);

    private ConfigEvent() {
    }

    public static <T> void addListener(ConfigEventListener<T> l) {
        if (SPI == null) {
            throw new ConfigException("No SPI registered for " + ConfigEvent.class.getName());
        }
        SPI.addListener(l);
    }

    public static <T> void removeListener(ConfigEventListener<T> l) {
        if (SPI == null) {
            throw new ConfigException("No SPI registered for " + ConfigEvent.class.getName());
        }
        SPI.removeListener(l);
    }

    public static void fireEvent(Object event) {
        ConfigEvent.fireEvent(event, event.getClass());
    }

    public static <T> void fireEvent(T event, Class<T> eventType) {
        if (SPI == null) {
            throw new ConfigException("No SPI registered for " + ConfigEvent.class.getName());
        }
        SPI.fireEvent(event, eventType);
    }
}

