/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.propertysource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.tamaya.spi.PropertySource;

public class SystemPropertySource
implements PropertySource {
    public static final int DEFAULT_ORDINAL = 1000;
    private volatile Map<String, String> cachedProperties = this.loadProperties();
    private int previousHash = System.getProperties().hashCode();

    private Map<String, String> loadProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Properties sysProps = System.getProperties();
        sysProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> props.put(k.toString(), v.toString())));
        return props;
    }

    public int getOrdinal() {
        return 1000;
    }

    public String getName() {
        return "system-properties";
    }

    public Map<String, String> getProperties() {
        if (this.previousHash != System.getProperties().hashCode()) {
            Properties systemProperties = System.getProperties();
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String propertyName : systemProperties.stringPropertyNames()) {
                properties.put(propertyName, System.getProperty(propertyName));
            }
            this.cachedProperties = Collections.unmodifiableMap(properties);
            this.previousHash = systemProperties.hashCode();
        }
        return this.cachedProperties;
    }
}

