/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.core.internal.converters.LongConverter;
import org.apache.tamaya.spi.PropertyConverter;

public class NumberConverter
implements PropertyConverter<Number> {
    private static final Logger LOGGER = Logger.getLogger(NumberConverter.class.getName());
    private LongConverter longConverter = new LongConverter();

    public Number convert(String value) {
        String trimmed = Objects.requireNonNull(value).trim();
        switch (trimmed.toUpperCase(Locale.ENGLISH)) {
            case "POSITIVE_INFINITY": {
                return Double.POSITIVE_INFINITY;
            }
            case "NEGATIVE_INFINITY": {
                return Double.NEGATIVE_INFINITY;
            }
            case "NAN": {
                return Double.NaN;
            }
        }
        Long lVal = this.longConverter.convert(trimmed);
        if (lVal != null) {
            return lVal;
        }
        try {
            return new BigDecimal(trimmed);
        }
        catch (Exception e) {
            LOGGER.finest("Unparseable Number: " + trimmed);
            return null;
        }
    }
}

