/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.spi.PropertyConverter;

public class IntegerConverter
implements PropertyConverter<Integer> {
    private static final Logger LOG = Logger.getLogger(IntegerConverter.class.getName());

    public Integer convert(String value) {
        String trimmed = Objects.requireNonNull(value).trim();
        switch (trimmed.toUpperCase(Locale.ENGLISH)) {
            case "MIN_VALUE": 
            case "MIN": {
                return Integer.MIN_VALUE;
            }
            case "MAX_VALUE": 
            case "MAX": {
                return Integer.MAX_VALUE;
            }
        }
        try {
            return Integer.decode(trimmed);
        }
        catch (Exception e) {
            LOG.finest(() -> "Unparseable Integer value: " + trimmed);
            return null;
        }
    }
}

