/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.core.internal.converters.IntegerConverter;
import org.apache.tamaya.spi.PropertyConverter;

public class FloatConverter
implements PropertyConverter<Float> {
    private static final Logger LOG = Logger.getLogger(FloatConverter.class.getName());
    private IntegerConverter integerConverter = new IntegerConverter();

    public Float convert(String value) {
        String trimmed = Objects.requireNonNull(value).trim();
        switch (trimmed.toUpperCase(Locale.ENGLISH)) {
            case "POSITIVE_INFINITY": {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            case "NEGATIVE_INFINITY": {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            case "NAN": {
                return Float.valueOf(Float.NaN);
            }
            case "MIN_VALUE": 
            case "MIN": {
                return Float.valueOf(Float.MIN_VALUE);
            }
            case "MAX_VALUE": 
            case "MAX": {
                return Float.valueOf(Float.MAX_VALUE);
            }
        }
        try {
            return Float.valueOf(trimmed);
        }
        catch (Exception e) {
            LOG.finest(() -> "Parsing of float as floating number failed, trying parsing integral number/hex instead...");
            Integer val = this.integerConverter.convert(trimmed);
            if (val != null) {
                return Float.valueOf(val.floatValue());
            }
            LOG.finest(() -> "Unparseable float value: " + trimmed);
            return null;
        }
    }
}

