/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.core.internal.converters.LongConverter;
import org.apache.tamaya.spi.PropertyConverter;

public class DoubleConverter
implements PropertyConverter<Double> {
    private static final Logger LOG = Logger.getLogger(DoubleConverter.class.getName());
    private LongConverter integerConverter = new LongConverter();

    public Double convert(String value) {
        String trimmed = Objects.requireNonNull(value).trim();
        switch (trimmed.toUpperCase(Locale.ENGLISH)) {
            case "POSITIVE_INFINITY": {
                return Double.POSITIVE_INFINITY;
            }
            case "NEGATIVE_INFINITY": {
                return Double.NEGATIVE_INFINITY;
            }
            case "NAN": {
                return Double.NaN;
            }
            case "MIN_VALUE": 
            case "MIN": {
                return Double.MIN_VALUE;
            }
            case "MAX_VALUE": 
            case "MAX": {
                return Double.MAX_VALUE;
            }
        }
        try {
            return Double.valueOf(trimmed);
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, e, () -> "Parsing of double as floating number failed, trying parsing integral/hex number instead...");
            Long val = this.integerConverter.convert(trimmed);
            if (val != null) {
                return val.doubleValue();
            }
            return null;
        }
    }
}

