/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.core.internal.converters.BigIntegerConverter;
import org.apache.tamaya.spi.PropertyConverter;

public class BigDecimalConverter
implements PropertyConverter<BigDecimal> {
    private static final Logger LOG = Logger.getLogger(BigDecimalConverter.class.getName());
    private BigIntegerConverter integerConverter = new BigIntegerConverter();

    public BigDecimal convert(String value) {
        String trimmed = Objects.requireNonNull(value).trim();
        try {
            return new BigDecimal(trimmed);
        }
        catch (Exception e) {
            LOG.finest(() -> "Parsing BigDecimal failed, trying BigInteger for: " + value);
            BigInteger bigInt = this.integerConverter.convert(trimmed);
            if (bigInt != null) {
                return new BigDecimal(bigInt);
            }
            LOG.finest(() -> "Failed to parse BigDecimal from: " + value);
            return null;
        }
    }
}

