/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.core.internal.DefaultConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;

public class DefaultConfigurationContextBuilder
implements ConfigurationContextBuilder {
    List<PropertySource> propertySources = new ArrayList<PropertySource>();
    List<PropertyFilter> propertyFilters = new ArrayList<PropertyFilter>();
    Map<TypeLiteral<?>, List<PropertyConverter<?>>> propertyConverters = new HashMap();
    PropertyValueCombinationPolicy combinationPolicy;

    public ConfigurationContextBuilder setContext(ConfigurationContext context) {
        this.propertySources.clear();
        this.propertySources.addAll(context.getPropertySources());
        this.propertyFilters.clear();
        this.propertyFilters.addAll(context.getPropertyFilters());
        this.propertyConverters.clear();
        this.propertyConverters.putAll(context.getPropertyConverters());
        this.combinationPolicy = context.getPropertyValueCombinationPolicy();
        return this;
    }

    public ConfigurationContextBuilder addPropertySources(Collection<PropertySource> propertySourcesToAdd) {
        Set names = this.propertySources.stream().map(ps -> ps.getName()).collect(Collectors.toSet());
        for (PropertySource ps2 : propertySourcesToAdd) {
            if (!names.contains(ps2.getName())) continue;
            throw new ConfigException("Duplicate PropertySource: " + ps2.getName());
        }
        this.propertySources.addAll(propertySourcesToAdd);
        return this;
    }

    public ConfigurationContextBuilder removePropertySources(Collection<String> propertySourcesToRemove) {
        this.propertySources = this.propertySources.stream().filter(ps -> !propertySourcesToRemove.contains(ps.getName())).collect(Collectors.toList());
        return this;
    }

    public ConfigurationContextBuilder addPropertyFilters(Collection<PropertyFilter> filters) {
        this.propertyFilters.addAll(filters);
        return this;
    }

    public ConfigurationContextBuilder removePropertyFilters(Predicate<PropertyFilter> selector) {
        Collection filtersToRemove = this.propertyFilters.stream().filter(selector).collect(Collectors.toList());
        this.propertyFilters.removeAll(filtersToRemove);
        return this;
    }

    public ConfigurationContextBuilder removePropertyFilters(Collection<PropertyFilter> filters) {
        this.propertyFilters.removeAll(filters);
        return this;
    }

    public ConfigurationContextBuilder removePropertySources(Predicate<PropertySource> selector) {
        Collection sourcesToRemove = this.propertySources.stream().filter(selector).collect(Collectors.toList());
        this.propertySources.removeAll(sourcesToRemove);
        return this;
    }

    public <T> ConfigurationContextBuilder addPropertyConverter(TypeLiteral<T> typeToConvert, PropertyConverter<T> propertyConverter) {
        List converters = this.propertyConverters.computeIfAbsent(typeToConvert, k -> new ArrayList());
        converters.add(propertyConverter);
        return this;
    }

    public ConfigurationContextBuilder removePropertyConverters(TypeLiteral<?> typeToConvert, PropertyConverter<?> ... converters) {
        return this.removePropertyConverters(typeToConvert, Arrays.asList(converters));
    }

    public ConfigurationContextBuilder removePropertyConverters(TypeLiteral<?> typeToConvert, Collection<PropertyConverter<?>> converters) {
        List<PropertyConverter<PropertyConverter<?>>> existing = this.propertyConverters.get(typeToConvert);
        if (existing != null) {
            existing.removeAll(converters);
        }
        return this;
    }

    public ConfigurationContextBuilder setPropertyValueCombinationPolicy(PropertyValueCombinationPolicy policy) {
        this.combinationPolicy = Objects.requireNonNull(policy);
        return this;
    }

    public ConfigurationContext build() {
        return new DefaultConfigurationContext(this);
    }
}

