/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.core.internal.DefaultConfigurationContextBuilder;
import org.apache.tamaya.core.internal.PropertyConverterManager;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;
import org.apache.tamaya.spi.ServiceContext;
import org.apache.tamaya.spi.ServiceContextManager;

public class DefaultConfigurationContext
implements ConfigurationContext {
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationContext.class.getName());
    private PropertyConverterManager propertyConverterManager = new PropertyConverterManager();
    private List<PropertySource> immutablePropertySources;
    private List<PropertyFilter> immutablePropertyFilters;
    private PropertyValueCombinationPolicy propertyValueCombinationPolicy;

    public DefaultConfigurationContext() {
        ArrayList<? extends PropertySource> propertySources = new ArrayList<PropertySource>();
        propertySources.addAll(ServiceContext.getInstance().getServices(PropertySource.class));
        propertySources.addAll(this.evaluatePropertySourcesFromProviders());
        Collections.sort(propertySources, this::comparePropertySources);
        this.immutablePropertySources = Collections.unmodifiableList(propertySources);
        LOG.info(() -> "Registered " + this.immutablePropertySources.size() + " property sources: " + this.createStringList(this.immutablePropertySources, ps -> ps.getName() + '[' + ps.getClass().getName() + ']'));
        ArrayList propertyFilters = new ArrayList();
        propertyFilters.addAll(ServiceContext.getInstance().getServices(PropertyFilter.class));
        Collections.sort(propertyFilters, this::comparePropertyFilters);
        this.immutablePropertyFilters = Collections.unmodifiableList(propertyFilters);
        LOG.info(() -> "Registered " + this.immutablePropertyFilters.size() + " property filters: " + this.createStringList(this.immutablePropertyFilters, f -> f.getClass().getName()));
        this.propertyValueCombinationPolicy = ServiceContext.getInstance().getService(PropertyValueCombinationPolicy.class).orElse(PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR);
        LOG.info(() -> "Using PropertyValueCombinationPolicy: " + this.propertyValueCombinationPolicy);
    }

    DefaultConfigurationContext(DefaultConfigurationContextBuilder builder) {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        propertySources.addAll(builder.propertySources);
        Collections.sort(propertySources, this::comparePropertySources);
        this.immutablePropertySources = Collections.unmodifiableList(propertySources);
        LOG.info(() -> "Registered " + this.immutablePropertySources.size() + " property sources: " + this.createStringList(this.immutablePropertySources, ps -> ps.getName() + '[' + ps.getClass().getName() + ']'));
        ArrayList propertyFilters = new ArrayList();
        propertyFilters.addAll(ServiceContext.getInstance().getServices(PropertyFilter.class));
        Collections.sort(propertyFilters, this::comparePropertyFilters);
        this.immutablePropertyFilters = Collections.unmodifiableList(propertyFilters);
        LOG.info(() -> "Registered " + this.immutablePropertyFilters.size() + " property filters: " + this.createStringList(this.immutablePropertyFilters, f -> f.getClass().getName()));
        this.propertyValueCombinationPolicy = ServiceContext.getInstance().getService(PropertyValueCombinationPolicy.class).orElse(PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR);
        LOG.info(() -> "Using PropertyValueCombinationPolicy: " + this.propertyValueCombinationPolicy);
    }

    private Collection<? extends PropertySource> evaluatePropertySourcesFromProviders() {
        ArrayList propertySources = new ArrayList();
        List propertySourceProviders = ServiceContext.getInstance().getServices(PropertySourceProvider.class);
        for (PropertySourceProvider propertySourceProvider : propertySourceProviders) {
            Collection sources = propertySourceProvider.getPropertySources();
            LOG.finer(() -> "PropertySourceProvider " + propertySourceProvider.getClass().getName() + " provided the following property sources: " + this.createStringList(sources, ps -> ps.getName() + '[' + ps.getClass().getName() + ']'));
            propertySources.addAll(sources);
        }
        return propertySources;
    }

    private int comparePropertySources(PropertySource source1, PropertySource source2) {
        if (source1.getOrdinal() < source2.getOrdinal()) {
            return -1;
        }
        if (source1.getOrdinal() > source2.getOrdinal()) {
            return 1;
        }
        return source1.getClass().getName().compareTo(source2.getClass().getName());
    }

    private int comparePropertyFilters(PropertyFilter filter1, PropertyFilter filter2) {
        int ord2;
        Priority prio1 = filter1.getClass().getAnnotation(Priority.class);
        Priority prio2 = filter2.getClass().getAnnotation(Priority.class);
        int ord1 = prio1 != null ? prio1.value() : 0;
        int n = ord2 = prio2 != null ? prio2.value() : 0;
        if (ord1 < ord2) {
            return -1;
        }
        if (ord1 > ord2) {
            return 1;
        }
        return filter1.getClass().getName().compareTo(filter2.getClass().getName());
    }

    public List<PropertySource> getPropertySources() {
        return this.immutablePropertySources;
    }

    public Map<TypeLiteral<?>, List<PropertyConverter<?>>> getPropertyConverters() {
        return this.propertyConverterManager.getPropertyConverters();
    }

    public <T> List<PropertyConverter<T>> getPropertyConverters(TypeLiteral<T> targetType) {
        return this.propertyConverterManager.getPropertyConverters(targetType);
    }

    public List<PropertyFilter> getPropertyFilters() {
        return this.immutablePropertyFilters;
    }

    public PropertyValueCombinationPolicy getPropertyValueCombinationPolicy() {
        return this.propertyValueCombinationPolicy;
    }

    public ConfigurationContextBuilder toBuilder() {
        ServiceContext serviceContext = ServiceContextManager.getServiceContext();
        Optional service = serviceContext.getService(ConfigurationContextBuilder.class);
        ((ConfigurationContextBuilder)service.get()).setContext((ConfigurationContext)this);
        return (ConfigurationContextBuilder)service.get();
    }

    private <T> String createStringList(Collection<T> propertySources, Function<T, String> mapper) {
        StringJoiner joiner = new StringJoiner(", ");
        propertySources.forEach(t -> joiner.add((CharSequence)mapper.apply(t)));
        return joiner.toString();
    }
}

