/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.events.ConfigEventListener;
import org.apache.tamaya.events.delta.ConfigurationContextChange;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertySource;

public class DefaultConfigurationContextChangeListener
implements ConfigEventListener<ConfigurationContextChange> {
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationContextChangeListener.class.getName());

    @Override
    public void onConfigEvent(ConfigurationContextChange event) {
        ConfigurationContext context = ConfigurationProvider.getConfigurationContext();
        ArrayList<PropertySource> affectedPropertySources = new ArrayList<PropertySource>();
        for (PropertySource ps : context.getPropertySources()) {
            if (!event.isAffected(ps)) continue;
            affectedPropertySources.add(ps);
        }
        ConfigurationContextBuilder newContextBuilder = ConfigurationProvider.getConfigurationContextBuilder().setContext(context);
        if (!affectedPropertySources.isEmpty()) {
            HashSet<String> propertySourceNames = new HashSet<String>();
            for (PropertySource removed : event.getRemovedPropertySources()) {
                propertySourceNames.add(removed.getName());
            }
            newContextBuilder.removePropertySources(propertySourceNames);
        }
        newContextBuilder.addPropertySources(event.getAddedPropertySources());
        newContextBuilder.addPropertySources(event.getUpdatedPropertySources());
        ConfigurationContext newContext = newContextBuilder.build();
        try {
            ConfigurationProvider.setConfigurationContext((ConfigurationContext)newContext);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to update the current ConfigurationContext due to config model changes", e);
        }
    }
}

