/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.events.ConfigEventListener;
import org.apache.tamaya.events.spi.ConfigEventSpi;
import org.apache.tamaya.spi.ServiceContextManager;

public class DefaultConfigEventSpi
implements ConfigEventSpi {
    private static final Logger LOG = Logger.getLogger(DefaultConfigEventSpi.class.getName());
    private Map<Type, List<ConfigEventListener>> listenerMap = new ConcurrentHashMap<Type, List<ConfigEventListener>>();

    public DefaultConfigEventSpi() {
        try {
            for (ConfigEventListener l : ServiceContextManager.getServiceContext().getServices(ConfigEventListener.class)) {
                try {
                    this.addListener(l);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to load configured listener: " + l.getClass().getName(), e);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to load configured listeners.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addListener(ConfigEventListener<T> l) {
        Type type = TypeLiteral.getGenericInterfaceTypeParameters(l.getClass(), ConfigEventListener.class)[0];
        List<ConfigEventListener<Object>> listeners = this.listenerMap.get(type);
        if (listeners == null) {
            listeners = Collections.synchronizedList(new ArrayList());
            this.listenerMap.put(type, listeners);
        }
        List<ConfigEventListener> list = listeners;
        synchronized (list) {
            if (!listeners.contains(l)) {
                listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void removeListener(ConfigEventListener<T> l) {
        Type type = TypeLiteral.getGenericInterfaceTypeParameters(l.getClass(), ConfigEventListener.class)[0];
        List<ConfigEventListener> listeners = this.listenerMap.get(type);
        if (listeners != null) {
            List<ConfigEventListener> list = listeners;
            synchronized (list) {
                listeners.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void fireEvent(T event, Class<T> eventType) {
        List<ConfigEventListener> listeners = this.listenerMap.get(eventType);
        if (listeners != null) {
            List<ConfigEventListener> list = listeners;
            synchronized (list) {
                for (ConfigEventListener l : listeners) {
                    l.onConfigEvent(event);
                }
            }
        }
    }
}

