/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.folderobserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.events.ConfigEvent;
import org.apache.tamaya.events.delta.ConfigurationContextChange;
import org.apache.tamaya.events.delta.ConfigurationContextChangeBuilder;
import org.apache.tamaya.events.folderobserver.FileChangeListener;
import org.apache.tamaya.events.folderobserver.FileChangeObserver;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormat;
import org.apache.tamaya.format.FlattenedDefaultPropertySource;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;

public class ObservingPropertySourceProvider
implements PropertySourceProvider,
FileChangeObserver {
    private static final Logger LOG = Logger.getLogger(ObservingPropertySourceProvider.class.getName());
    private final List<PropertySource> propertySources = Collections.synchronizedList(new LinkedList());
    private Collection<ConfigurationFormat> formats = new ArrayList<ConfigurationFormat>();
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public ObservingPropertySourceProvider(ConfigurationFormat ... formats) {
        this((Path)null, formats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservingPropertySourceProvider(Path directory, ConfigurationFormat ... formats) {
        this.formats = Arrays.asList(formats);
        if (directory == null) {
            directory = this.getDirectory();
        }
        if (Objects.nonNull(directory)) {
            List<PropertySource> list = this.propertySources;
            synchronized (list) {
                this.propertySources.addAll(this.readConfiguration(directory));
            }
            FileChangeListener runnable = new FileChangeListener(directory, this);
            this.executor.execute(runnable);
        } else {
            this.executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertySource> readConfiguration(Path directory) {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        try {
            List<PropertySource> list = this.propertySources;
            synchronized (list) {
                for (Path path : Files.newDirectoryStream(directory, "*")) {
                    ConfigurationData data = this.loadFile(path);
                    if (data == null) continue;
                    result.addAll(this.getPropertySources(data));
                }
                return result;
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to read configuration from dir: " + directory, e);
            return result;
        }
    }

    protected Collection<PropertySource> getPropertySources(ConfigurationData data) {
        return Arrays.asList(new FlattenedDefaultPropertySource(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigurationData loadFile(Path file) {
        InputStream is = null;
        for (ConfigurationFormat format : this.formats) {
            try {
                URL url = file.toUri().toURL();
                if (!format.accepts(url)) continue;
                is = url.openStream();
                ConfigurationData data = format.readConfiguration(file.toString(), is);
                if (data == null) continue;
                ConfigurationData configurationData = data;
                return configurationData;
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Error reading file: " + file.toString() + ", using format: " + format, e);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    LOG.log(Level.SEVERE, "Failed to rea data...", ioe);
                }
            }
        }
        LOG.warning("Error reading file: " + file.toString());
        return null;
    }

    private Path getDirectory() {
        Path path;
        String absolutePath = System.getProperty("tamaya.configdir");
        if (Objects.nonNull(absolutePath) && Files.isDirectory(path = Paths.get(absolutePath, new String[0]), new LinkOption[0])) {
            return path;
        }
        URL resource = ObservingPropertySourceProvider.class.getResource("/META-INF/config/");
        if (Objects.nonNull(resource)) {
            try {
                return Paths.get(resource.toURI());
            }
            catch (URISyntaxException e) {
                throw new ConfigException("An error to find the directory to watch", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void directoryChanged(Path directory) {
        List<PropertySource> list = this.propertySources;
        synchronized (list) {
            ArrayList<PropertySource> existingPropertySources = new ArrayList<PropertySource>(this.propertySources);
            this.propertySources.clear();
            List<PropertySource> sourcesRead = this.readConfiguration(directory);
            this.propertySources.addAll(sourcesRead);
            this.triggerConfigChange(existingPropertySources, this.propertySources);
        }
    }

    private void triggerConfigChange(List<PropertySource> originalPropertySources, List<PropertySource> newPropertySources) {
        ConfigurationContextChangeBuilder b = ConfigurationContextChangeBuilder.of();
        for (PropertySource ps : originalPropertySources) {
            b.removedPropertySource(ps);
        }
        for (PropertySource ps : newPropertySources) {
            b.newPropertySource(ps);
        }
        ConfigurationContextChange changeEvent = b.build();
        LOG.fine("Trigger Config Context Change: " + changeEvent);
        ConfigEvent.fireEvent(changeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PropertySource> getPropertySources() {
        List<PropertySource> list = this.propertySources;
        synchronized (list) {
            return new ArrayList<PropertySource>(this.propertySources);
        }
    }
}

