/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.delta;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tamaya.events.delta.ChangeType;
import org.apache.tamaya.events.delta.PropertySourceChange;
import org.apache.tamaya.spi.PropertySource;

public final class PropertySourceChangeBuilder {
    final SortedMap<String, PropertyChangeEvent> delta = new TreeMap<String, PropertyChangeEvent>();
    PropertySource source;
    String version;
    Long timestamp;
    ChangeType changeType;

    private PropertySourceChangeBuilder(PropertySource source, ChangeType changeType) {
        this.source = Objects.requireNonNull(source);
        this.changeType = Objects.requireNonNull(changeType);
    }

    public static PropertySourceChangeBuilder of(PropertySource source, ChangeType changeType) {
        return new PropertySourceChangeBuilder(source, changeType);
    }

    public static Collection<PropertyChangeEvent> compare(PropertySource map1, PropertySource map2) {
        String val;
        ArrayList<PropertyChangeEvent> changes = new ArrayList<PropertyChangeEvent>();
        for (Map.Entry en : map1.getProperties().entrySet()) {
            val = map2.get((String)en.getKey());
            if (val == null) {
                changes.add(new PropertyChangeEvent(map1, (String)en.getKey(), null, en.getValue()));
                continue;
            }
            if (val.equals(en.getValue())) continue;
            changes.add(new PropertyChangeEvent(map1, (String)en.getKey(), val, en.getValue()));
        }
        for (Map.Entry en : map2.getProperties().entrySet()) {
            val = map1.get((String)en.getKey());
            if (val == null) {
                changes.add(new PropertyChangeEvent(map1, (String)en.getKey(), en.getValue(), null));
                continue;
            }
            if (val.equals(en.getValue())) continue;
            changes.add(new PropertyChangeEvent(map1, (String)en.getKey(), en.getValue(), val));
        }
        return changes;
    }

    public PropertySourceChangeBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public PropertySourceChangeBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public PropertySourceChangeBuilder addChanges(PropertySource newState) {
        Collection<PropertyChangeEvent> events = PropertySourceChangeBuilder.compare(newState, this.source);
        for (PropertyChangeEvent c : events) {
            this.delta.put(c.getPropertyName(), c);
        }
        return this;
    }

    public String get(String key) {
        PropertyChangeEvent change = (PropertyChangeEvent)this.delta.get(key);
        if (change != null && change.getNewValue() != null) {
            return (String)change.getNewValue();
        }
        return null;
    }

    public PropertySourceChangeBuilder remove(String key, String ... otherKeys) {
        String oldValue = this.source.get(key);
        if (oldValue == null) {
            this.delta.remove(key);
        }
        this.delta.put(key, new PropertyChangeEvent(this.source, key, oldValue, null));
        for (String addKey : otherKeys) {
            oldValue = this.source.get(addKey);
            if (oldValue == null) {
                this.delta.remove(addKey);
            }
            this.delta.put(addKey, new PropertyChangeEvent(this.source, addKey, oldValue, null));
        }
        return this;
    }

    public PropertySourceChangeBuilder putAll(Map<String, String> changes) {
        changes.putAll(changes);
        return this;
    }

    public PropertySourceChangeBuilder deleteAll() {
        this.delta.clear();
        for (Map.Entry en : this.source.getProperties().entrySet()) {
            this.delta.put((String)en.getKey(), new PropertyChangeEvent(this.source, (String)en.getKey(), en.getValue(), null));
        }
        return this;
    }

    public boolean isEmpty() {
        return this.delta.isEmpty();
    }

    public void reset() {
        this.delta.clear();
    }

    public PropertySourceChangeBuilder setChangeType(ChangeType changeType) {
        this.changeType = changeType;
        return this;
    }

    public PropertySourceChange build() {
        return new PropertySourceChange(this);
    }

    public String toString() {
        return "PropertiesChangeBuilder [source=" + this.source + ", " + ", delta=" + this.delta + "]";
    }
}

