/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.delta;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tamaya.events.FrozenPropertySource;
import org.apache.tamaya.events.delta.ChangeType;
import org.apache.tamaya.events.delta.PropertySourceChangeBuilder;
import org.apache.tamaya.spi.PropertySource;

public final class PropertySourceChange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FrozenPropertySource propertySource;
    private String version = UUID.randomUUID().toString();
    private long timestamp = System.currentTimeMillis();
    private Map<String, PropertyChangeEvent> changes = new HashMap<String, PropertyChangeEvent>();
    private ChangeType changeType;

    PropertySourceChange(PropertySourceChangeBuilder builder) {
        this.propertySource = FrozenPropertySource.of(builder.source);
        for (PropertyChangeEvent c : builder.delta.values()) {
            this.changes.put(c.getPropertyName(), c);
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        this.changeType = builder.changeType;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public PropertySource getPropertySource() {
        return this.propertySource;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Collection<PropertyChangeEvent> getEvents() {
        return Collections.unmodifiableCollection(this.changes.values());
    }

    public int getRemovedSize() {
        int removedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getNewValue() != null) continue;
            ++removedCount;
        }
        return removedCount;
    }

    public int getAddedSize() {
        int addedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getOldValue() != null || ev.getNewValue() == null) continue;
            ++addedCount;
        }
        return addedCount;
    }

    public int getUpdatedSize() {
        int updatedCount = 0;
        for (PropertyChangeEvent ev : this.changes.values()) {
            if (ev.getOldValue() == null || ev.getNewValue() == null) continue;
            ++updatedCount;
        }
        return updatedCount;
    }

    public boolean isRemoved(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getNewValue() == null;
    }

    public boolean isAdded(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getOldValue() == null;
    }

    public boolean isUpdated(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getOldValue() != null && change.getNewValue() != null;
    }

    public boolean containsKey(String key) {
        PropertyChangeEvent change = this.changes.get(key);
        return change != null && change.getNewValue() != null;
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public static PropertySourceChange ofAdded(PropertySource propertySource) {
        return PropertySourceChangeBuilder.of(propertySource, ChangeType.NEW).build();
    }

    public static PropertySourceChange ofDeleted(PropertySource propertySource) {
        return PropertySourceChangeBuilder.of(propertySource, ChangeType.DELETED).build();
    }

    public String toString() {
        return "PropertySourceChange{changeType=" + (Object)((Object)this.changeType) + ", propertySource=" + this.propertySource + ", version='" + this.version + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

