/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.events.delta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.tamaya.events.delta.ChangeType;
import org.apache.tamaya.events.delta.ConfigurationContextChangeBuilder;
import org.apache.tamaya.events.delta.PropertySourceChange;
import org.apache.tamaya.spi.PropertySource;

public final class ConfigurationContextChange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<PropertySourceChange> changedPropertySources = new ArrayList<PropertySourceChange>();
    private String version = UUID.randomUUID().toString();
    private long timestamp = System.currentTimeMillis();

    public static ConfigurationContextChange emptyChangeSet() {
        return ConfigurationContextChangeBuilder.of().build();
    }

    ConfigurationContextChange(ConfigurationContextChangeBuilder builder) {
        this.changedPropertySources.addAll(builder.changedPropertySources);
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Collection<PropertySourceChange> getPropertySourceChanges() {
        return Collections.unmodifiableCollection(this.changedPropertySources);
    }

    public Collection<PropertySourceChange> getPropertySourceUpdates() {
        ArrayList<PropertySourceChange> result = new ArrayList<PropertySourceChange>();
        for (PropertySourceChange pc : this.changedPropertySources) {
            if (pc.getChangeType() != ChangeType.UPDATED) continue;
            result.add(pc);
        }
        return result;
    }

    public Collection<PropertySource> getRemovedPropertySources() {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (PropertySourceChange pc : this.changedPropertySources) {
            if (pc.getChangeType() != ChangeType.DELETED) continue;
            result.add(pc.getPropertySource());
        }
        return result;
    }

    public Collection<PropertySource> getAddedPropertySources() {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (PropertySourceChange pc : this.changedPropertySources) {
            if (pc.getChangeType() != ChangeType.NEW) continue;
            result.add(pc.getPropertySource());
        }
        return result;
    }

    public Collection<PropertySource> getUpdatedPropertySources() {
        ArrayList<PropertySource> result = new ArrayList<PropertySource>();
        for (PropertySourceChange pc : this.changedPropertySources) {
            if (pc.getChangeType() != ChangeType.UPDATED) continue;
            result.add(pc.getPropertySource());
        }
        return result;
    }

    public boolean isAffected(PropertySource propertySource) {
        for (PropertySourceChange ps : this.changedPropertySources) {
            if (ps.getPropertySource() != propertySource && !ps.getPropertySource().getName().equals(propertySource.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.changedPropertySources.isEmpty();
    }

    public String toString() {
        return "ConfigurationContextChange{changedPropertySources=" + this.changedPropertySources + ", version='" + this.version + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

