/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

final class Locator {
    private List<String> tokens;

    Locator(List<String> tokens) {
        this.tokens = tokens;
    }

    public static Locator of(String expression) {
        ArrayList<String> expressions = new ArrayList<String>();
        for (String expr : expression.split("/")) {
            expressions.add(expr);
        }
        return new Locator(expressions);
    }

    public String getRootPath() {
        StringJoiner sj = new StringJoiner("/");
        for (String token : this.tokens) {
            if (this.containsPlaceholder(token)) break;
            sj.add(token);
        }
        return sj.toString();
    }

    public String getSubPath() {
        StringJoiner sj = new StringJoiner("/");
        for (String token : this.getSubPathTokens()) {
            sj.add(token);
        }
        return sj.toString();
    }

    public List<String> getSubPathTokens() {
        ArrayList<String> subTokens = new ArrayList<String>();
        boolean subTokensStarted = false;
        for (String token : this.tokens) {
            if (subTokensStarted) {
                subTokens.add(token);
                continue;
            }
            if (!this.containsPlaceholder(token)) continue;
            subTokensStarted = true;
            subTokens.add(token);
        }
        return subTokens;
    }

    public String getPath() {
        StringJoiner sj = new StringJoiner("/");
        for (String token : this.tokens) {
            sj.add(token);
        }
        return sj.toString();
    }

    private boolean containsPlaceholder(String token) {
        return token.contains("*") || token.contains("?");
    }

    public String toString() {
        return "Locator: " + this.getPath();
    }
}

