/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.event.PropertyChangeSet;
import org.apache.tamaya.inject.internal.PropertyChangeSetListener;

public final class WeakConfigListenerManager {
    private static final WeakConfigListenerManager INSTANCE = new WeakConfigListenerManager();
    private static final Logger LOG = Logger.getLogger(WeakConfigListenerManager.class.getName());
    private StampedLock lock = new StampedLock();
    private Map<Object, PropertyChangeSetListener> listenerReferences = new WeakHashMap<Object, PropertyChangeSetListener>();

    private WeakConfigListenerManager() {
    }

    public static WeakConfigListenerManager of() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConsumer(Object instance, final PropertyChangeSetListener listener) {
        Lock writeLock = this.lock.asWriteLock();
        try {
            writeLock.lock();
            final PropertyChangeSetListener l = this.listenerReferences.get(instance);
            if (l == null) {
                this.listenerReferences.put(instance, listener);
            } else {
                this.listenerReferences.put(instance, new PropertyChangeSetListener(){

                    @Override
                    public void propertyChange(PropertyChangeSet evt) {
                        l.propertyChange(evt);
                        listener.propertyChange(evt);
                    }
                });
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void unregisterConsumer(Object instance) {
        Lock writeLock = this.lock.asWriteLock();
        try {
            writeLock.lock();
            this.listenerReferences.remove(instance);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishChangeEvent(PropertyChangeSet change) {
        Lock readLock = this.lock.asReadLock();
        try {
            readLock.lock();
            for (PropertyChangeSetListener l : this.listenerReferences.values()) {
                try {
                    l.propertyChange(change);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "ConfigChangeListener failed: " + l.getClass().getName(), e);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    public String toString() {
        return "WeakConfigListenerManager{listenerReferences=" + this.listenerReferences + '}';
    }
}

