/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.ConfiguredProperty;
import org.apache.tamaya.inject.ConfiguredType;
import org.apache.tamaya.inject.DefaultValue;
import org.apache.tamaya.inject.WithPropertyConverter;
import org.apache.tamaya.resolver.spi.ExpressionEvaluator;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.ServiceContextManager;

final class InjectionUtils {
    private static final Logger LOG = Logger.getLogger(InjectionUtils.class.getName());
    private static final boolean RESOLUTION_MODULE_LOADED = InjectionUtils.checkResolutionModuleLoaded();

    private static boolean checkResolutionModuleLoaded() {
        try {
            Class.forName("org.apache.tamaya.resolver.internal.DefaultExpressionEvaluator");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private InjectionUtils() {
    }

    public static List<String> evaluateKeys(Member member, ConfiguredType areasAnnot, ConfiguredProperty propertyAnnotation) {
        if (propertyAnnotation == null) {
            return InjectionUtils.evaluateKeys(member, areasAnnot);
        }
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList(propertyAnnotation.keys()));
        if (keys.isEmpty()) {
            keys.add(member.getName());
        }
        ListIterator<String> iterator = keys.listIterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (next.startsWith("[") && next.endsWith("]")) {
                iterator.set(next.substring(1, next.length() - 1));
                continue;
            }
            if (areasAnnot == null) continue;
            iterator.remove();
            for (String area : areasAnnot.defaultSections()) {
                iterator.add(area.isEmpty() ? next : area + '.' + next);
            }
        }
        return keys;
    }

    public static List<String> evaluateKeys(Member member, ConfiguredType areasAnnot) {
        ArrayList<String> keys = new ArrayList<String>();
        String name = member.getName();
        String mainKey = name.startsWith("get") || name.startsWith("set") ? Character.toLowerCase(name.charAt(3)) + name.substring(4) : Character.toLowerCase(name.charAt(0)) + name.substring(1);
        keys.add(mainKey);
        if (areasAnnot != null) {
            for (String area : areasAnnot.defaultSections()) {
                if (area.isEmpty()) continue;
                keys.add(area + '.' + mainKey);
            }
        } else {
            keys.add(member.getDeclaringClass().getName() + '.' + mainKey);
        }
        return keys;
    }

    public static String getConfigValue(Method method) {
        ConfiguredType areasAnnot = method.getDeclaringClass().getAnnotation(ConfiguredType.class);
        return InjectionUtils.getConfigValueInternal(method, areasAnnot);
    }

    public static String getConfigValue(Field field) {
        ConfiguredType areasAnnot = field.getDeclaringClass().getAnnotation(ConfiguredType.class);
        return InjectionUtils.getConfigValueInternal(field, areasAnnot);
    }

    private static String getConfigValueInternal(AnnotatedElement element, ConfiguredType areasAnnot) {
        ConfiguredProperty prop = element.getAnnotation(ConfiguredProperty.class);
        DefaultValue defaultAnnot = element.getAnnotation(DefaultValue.class);
        List<String> keys = prop == null ? InjectionUtils.evaluateKeys((Member)((Object)element), areasAnnot) : InjectionUtils.evaluateKeys((Member)((Object)element), areasAnnot, prop);
        String configValue = InjectionUtils.evaluteConfigValue(keys);
        if (configValue == null && defaultAnnot != null) {
            return defaultAnnot.value();
        }
        return configValue;
    }

    public static List<String> getKeys(Field field) {
        ConfiguredType areasAnnot = field.getDeclaringClass().getAnnotation(ConfiguredType.class);
        return InjectionUtils.evaluateKeys(field, areasAnnot, field.getAnnotation(ConfiguredProperty.class));
    }

    public static List<String> getKeys(Method method) {
        ConfiguredType areasAnnot = method.getDeclaringClass().getAnnotation(ConfiguredType.class);
        return InjectionUtils.evaluateKeys(method, areasAnnot, method.getAnnotation(ConfiguredProperty.class));
    }

    private static String evaluteConfigValue(List<String> keys) {
        String configValue = null;
        for (String key : keys) {
            configValue = ConfigurationProvider.getConfiguration().get(key);
            if (configValue == null) continue;
            break;
        }
        return configValue;
    }

    public static <T> T adaptValue(AnnotatedElement element, TypeLiteral<T> targetType, String configValue) {
        Class<PropertyConverter<?>> converterType;
        Object adaptedValue = null;
        WithPropertyConverter converterAnnot = element.getAnnotation(WithPropertyConverter.class);
        if (converterAnnot != null && !(converterType = converterAnnot.value()).getName().equals(WithPropertyConverter.class.getName())) {
            try {
                PropertyConverter converter = (PropertyConverter)PropertyConverter.class.cast(converterType.newInstance());
                adaptedValue = converter.convert(configValue);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to convert using explicit PropertyConverter on " + element + ", trying default conversion.", e);
            }
        }
        if (adaptedValue != null) {
            return (T)adaptedValue;
        }
        if (String.class == targetType.getType()) {
            return (T)configValue;
        }
        List converters = ConfigurationProvider.getConfigurationContext().getPropertyConverters(targetType);
        for (PropertyConverter converter : converters) {
            adaptedValue = converter.convert(configValue);
            if (adaptedValue == null) continue;
            return (T)adaptedValue;
        }
        throw new ConfigException("Non convertible property type: " + element);
    }

    public static boolean isResolutionModuleLoaded() {
        return RESOLUTION_MODULE_LOADED;
    }

    public static String evaluateValue(String expression) {
        if (!RESOLUTION_MODULE_LOADED) {
            return expression;
        }
        ExpressionEvaluator evaluator = (ExpressionEvaluator)ServiceContextManager.getServiceContext().getService(ExpressionEvaluator.class);
        if (evaluator != null) {
            return evaluator.evaluateExpression("<injection>", expression);
        }
        return expression;
    }
}

