/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.ConfiguredItemSupplier;
import org.apache.tamaya.inject.DynamicValue;
import org.apache.tamaya.inject.WithPropertyConverter;
import org.apache.tamaya.inject.internal.InjectionUtils;
import org.apache.tamaya.spi.PropertyConverter;

public final class DefaultDynamicValue<T>
implements DynamicValue<T>,
Serializable {
    private static final long serialVersionUID = -2071172847144537443L;
    private String propertyName;
    private String[] keys;
    private Configuration configuration;
    private TypeLiteral<T> targetType;
    private PropertyConverter<T> propertyConverter;
    private DynamicValue.UpdatePolicy updatePolicy = DynamicValue.UpdatePolicy.NEVER;
    private transient T value;
    private transient T newValue;
    private transient WeakList<PropertyChangeListener> listeners;

    private DefaultDynamicValue(String propertyName, Configuration configuration, TypeLiteral<T> targetType, PropertyConverter<T> propertyConverter, List<String> keys) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.keys = keys.toArray(new String[keys.size()]);
        this.configuration = Objects.requireNonNull(configuration);
        this.propertyConverter = propertyConverter;
        this.targetType = targetType;
        this.value = this.evaluateValue();
    }

    public static DynamicValue of(Field annotatedField, Configuration configuration) {
        Type targetType = annotatedField.getGenericType();
        if (targetType == null) {
            throw new ConfigException("Failed to evaluate target type for " + annotatedField.getAnnotatedType().getType().getTypeName() + '.' + annotatedField.getName());
        }
        if (targetType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)targetType;
            Type[] types = pt.getActualTypeArguments();
            if (types.length != 1) {
                throw new ConfigException("Failed to evaluate target type for " + annotatedField.getAnnotatedType().getType().getTypeName() + '.' + annotatedField.getName());
            }
            targetType = (Class)types[0];
        }
        PropertyConverter<?> propertyConverter = null;
        WithPropertyConverter annot = annotatedField.getAnnotation(WithPropertyConverter.class);
        if (annot != null) {
            try {
                propertyConverter = annot.value().newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Failed to instantiate annotated PropertyConverter on " + annotatedField.getAnnotatedType().getType().getTypeName() + '.' + annotatedField.getName(), (Throwable)e);
            }
        }
        List<String> keys = InjectionUtils.getKeys(annotatedField);
        return new DefaultDynamicValue(annotatedField.getName(), configuration, TypeLiteral.of((Type)targetType), propertyConverter, keys);
    }

    public static DynamicValue of(Method method, Configuration configuration) {
        Type targetType = method.getGenericReturnType();
        if (targetType == null) {
            throw new ConfigException("Failed to evaluate target type for " + method.getDeclaringClass().getTypeName() + '.' + method.getName());
        }
        if (targetType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)targetType;
            Type[] types = pt.getActualTypeArguments();
            if (types.length != 1) {
                throw new ConfigException("Failed to evaluate target type for " + method.getDeclaringClass().getTypeName() + '.' + method.getName());
            }
            targetType = (Class)types[0];
        }
        PropertyConverter<?> propertyConverter = null;
        WithPropertyConverter annot = method.getAnnotation(WithPropertyConverter.class);
        if (annot != null) {
            try {
                propertyConverter = annot.value().newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Failed to instantiate annotated PropertyConverter on " + method.getDeclaringClass().getTypeName() + '.' + method.getName(), (Throwable)e);
            }
        }
        return new DefaultDynamicValue(method.getName(), configuration, TypeLiteral.of((Type)targetType), propertyConverter, InjectionUtils.getKeys(method));
    }

    @Override
    public T commitAndGet() {
        this.commit();
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        DefaultDynamicValue defaultDynamicValue = this;
        synchronized (defaultDynamicValue) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, this.propertyName, this.value, this.newValue);
            this.value = this.newValue;
            this.newValue = null;
            if (this.listeners != null) {
                for (PropertyChangeListener consumer : this.listeners.get()) {
                    consumer.propertyChange(evt);
                }
            }
        }
    }

    @Override
    public void discard() {
        this.newValue = null;
    }

    @Override
    public DynamicValue.UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    @Override
    public void setUpdatePolicy(DynamicValue.UpdatePolicy updatePolicy) {
        this.updatePolicy = Objects.requireNonNull(updatePolicy);
    }

    @Override
    public void addListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new WeakList();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeListener(PropertyChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public boolean updateValue() {
        T newValue = this.evaluateValue();
        if (Objects.equals(newValue, this.value)) {
            return false;
        }
        switch (this.updatePolicy) {
            case IMMEDIATE: {
                this.newValue = newValue;
                this.commit();
                break;
            }
            case LOG_AND_DISCARD: {
                Logger.getLogger(this.getClass().getName()).info("Discard change on " + this + ", newValue=" + newValue);
                this.newValue = null;
                break;
            }
            case NEVER: {
                this.newValue = null;
                break;
            }
            default: {
                this.newValue = newValue;
            }
        }
        return true;
    }

    @Override
    public T evaluateValue() {
        Object value = null;
        for (String key : this.keys) {
            if (this.propertyConverter == null) {
                value = this.configuration.get(key, this.targetType);
            } else {
                String source = this.configuration.get(key);
                value = this.propertyConverter.convert(source);
            }
            if (value != null) break;
        }
        return (T)value;
    }

    @Override
    public T getNewValue() {
        T nv = this.newValue;
        if (nv != null) {
            return nv;
        }
        return null;
    }

    @Override
    public boolean isPresent() {
        return this.value != null;
    }

    @Override
    public T orElse(T other) {
        if (this.value == null) {
            return other;
        }
        return this.value;
    }

    @Override
    public T orElseGet(ConfiguredItemSupplier<? extends T> other) {
        if (this.value == null) {
            return other.get();
        }
        return this.value;
    }

    @Override
    public <X extends Throwable> T orElseThrow(ConfiguredItemSupplier<? extends X> exceptionSupplier) throws X {
        if (this.value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject((Object)this.updatePolicy);
        if (this.isPresent()) {
            oos.writeObject(this.value);
        } else {
            oos.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.updatePolicy = (DynamicValue.UpdatePolicy)((Object)ois.readObject());
        if (this.isPresent()) {
            this.value = ois.readObject();
        }
        this.newValue = null;
    }

    private class WeakList<I> {
        final List<WeakReference<I>> refs = new LinkedList<WeakReference<I>>();

        private WeakList() {
        }

        void add(I t) {
            this.refs.add(new WeakReference<I>(t));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(I t) {
            List<WeakReference<I>> list = this.refs;
            synchronized (list) {
                Iterator<WeakReference<I>> iterator = this.refs.iterator();
                while (iterator.hasNext()) {
                    WeakReference<I> ref = iterator.next();
                    Object instance = ref.get();
                    if (instance != null && instance != t) continue;
                    iterator.remove();
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<I> get() {
            List<WeakReference<I>> list = this.refs;
            synchronized (list) {
                ArrayList res = new ArrayList();
                Iterator<WeakReference<I>> iterator = this.refs.iterator();
                while (iterator.hasNext()) {
                    WeakReference<I> ref = iterator.next();
                    Object instance = ref.get();
                    if (instance == null) {
                        iterator.remove();
                        continue;
                    }
                    res.add(instance);
                }
                return res;
            }
        }
    }
}

