/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.inject.ConfigurationInjector;
import org.apache.tamaya.inject.ConfiguredItemSupplier;
import org.apache.tamaya.inject.internal.ConfigTemplateInvocationHandler;
import org.apache.tamaya.inject.internal.ConfiguredType;

@Priority(value=0)
public final class DefaultConfigurationInjector
implements ConfigurationInjector {
    private Map<Class, ConfiguredType> configuredTypes = new ConcurrentHashMap<Class, ConfiguredType>();

    public ConfiguredType registerTypeInternal(Class<?> type) {
        ConfiguredType confType = this.configuredTypes.get(type);
        if (confType == null) {
            confType = new ConfiguredType(type);
            this.configuredTypes.put(type, confType);
        }
        return confType;
    }

    void registerType(Class<?> type) {
        this.registerTypeInternal(type);
    }

    @Override
    public <T> T configure(T instance) {
        Class<?> type = Objects.requireNonNull(instance).getClass();
        ConfiguredType configuredType = this.registerTypeInternal(type);
        Objects.requireNonNull(configuredType).configure(instance);
        return instance;
    }

    @Override
    public <T> T createTemplate(Class<T> templateType) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return (T)Proxy.newProxyInstance(cl, new Class[]{ConfiguredItemSupplier.class, Objects.requireNonNull(templateType)}, (InvocationHandler)new ConfigTemplateInvocationHandler(templateType, ConfigurationProvider.getConfiguration()));
    }

    @Override
    public <T> ConfiguredItemSupplier<T> getConfiguredSupplier(final ConfiguredItemSupplier<T> supplier) {
        return new ConfiguredItemSupplier<T>(){

            @Override
            public T get() {
                return supplier.get();
            }
        };
    }
}

