/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.event.ObservesConfigChange;
import org.apache.tamaya.event.PropertyChangeSet;
import org.apache.tamaya.inject.ConfiguredProperty;
import org.apache.tamaya.inject.NoConfig;
import org.apache.tamaya.inject.internal.ConfigChangeCallbackMethod;
import org.apache.tamaya.inject.internal.ConfiguredField;
import org.apache.tamaya.inject.internal.ConfiguredSetterMethod;
import org.apache.tamaya.inject.internal.WeakConfigListenerManager;

public class ConfiguredType {
    private static final Logger LOG = Logger.getLogger(ConfiguredType.class.getName());
    private List<ConfiguredField> configuredFields = new ArrayList<ConfiguredField>();
    private List<ConfiguredSetterMethod> configuredSetterMethods = new ArrayList<ConfiguredSetterMethod>();
    private List<ConfigChangeCallbackMethod> callbackMethods = new ArrayList<ConfigChangeCallbackMethod>();
    private Class type;

    public ConfiguredType(Class type) {
        this.type = Objects.requireNonNull(type);
        this.initFields(type);
        this.initMethods(type);
    }

    private void initFields(Class type) {
        for (Field f : type.getDeclaredFields()) {
            if (f.isAnnotationPresent(NoConfig.class)) {
                LOG.finest("Ignored @NoConfig annotated field " + f.getClass().getName() + "#" + f.toGenericString());
                continue;
            }
            if (Modifier.isFinal(f.getModifiers())) {
                LOG.finest("Ignored final field " + f.getClass().getName() + "#" + f.toGenericString());
                continue;
            }
            if (f.isSynthetic()) {
                LOG.finest("Ignored synthetic field " + f.getClass().getName() + "#" + f.toGenericString());
                continue;
            }
            try {
                ConfiguredField configuredField = new ConfiguredField(f);
                this.configuredFields.add(configuredField);
                LOG.finer("Registered field " + f.getClass().getName() + "#" + f.toGenericString());
            }
            catch (Exception e) {
                throw new ConfigException("Failed to initialized configured field: " + f.getDeclaringClass().getName() + '.' + f.getName(), (Throwable)e);
            }
        }
    }

    private void initMethods(Class type) {
        for (Method m : type.getDeclaredMethods()) {
            if (m.isAnnotationPresent(NoConfig.class)) {
                LOG.finest("Ignored @NoConfig annotated method " + m.getClass().getName() + "#" + m.toGenericString());
                continue;
            }
            if (m.isSynthetic()) {
                LOG.finest("Ignored synthetic method " + m.getClass().getName() + "#" + m.toGenericString());
                continue;
            }
            ObservesConfigChange observesAnnot = m.getAnnotation(ObservesConfigChange.class);
            ConfiguredProperty propAnnot = m.getAnnotation(ConfiguredProperty.class);
            if (type.isInterface()) {
                if (observesAnnot == null || !m.isDefault() || !this.addObserverMethod(m)) continue;
                LOG.finer("Added configured observer for template: " + m.getClass().getName() + "#" + m.toGenericString());
                continue;
            }
            if (observesAnnot != null) {
                if (!this.addObserverMethod(m)) continue;
                LOG.finer("Added configured observer: " + m.getClass().getName() + "#" + m.toGenericString());
                continue;
            }
            if (!this.addPropertySetter(m, propAnnot)) continue;
            LOG.finer("Added configured setter: " + m.getClass().getName() + "#" + m.toGenericString());
        }
    }

    private boolean addPropertySetter(Method m, ConfiguredProperty prop) {
        Class<?> returnType;
        if (prop != null && m.getParameterTypes().length == 1 && Void.TYPE.equals(returnType = m.getReturnType())) {
            try {
                this.configuredSetterMethods.add(new ConfiguredSetterMethod(m));
                return true;
            }
            catch (Exception e) {
                throw new ConfigException("Failed to initialized configured setter method: " + m.getDeclaringClass().getName() + '.' + m.getName(), (Throwable)e);
            }
        }
        return false;
    }

    private boolean addObserverMethod(Method m) {
        if (m.getParameterTypes().length != 1) {
            return false;
        }
        if (!m.getParameterTypes()[0].equals(PropertyChangeSet.class)) {
            return false;
        }
        if (!Void.TYPE.equals(m.getReturnType())) {
            return false;
        }
        try {
            this.callbackMethods.add(new ConfigChangeCallbackMethod(m));
            return true;
        }
        catch (Exception e) {
            throw new ConfigException("Failed to initialized configured callback method: " + m.getDeclaringClass().getName() + '.' + m.getName(), (Throwable)e);
        }
    }

    public void configure(Object instance) {
        for (ConfiguredField field : this.configuredFields) {
            field.applyValue(instance);
        }
        for (ConfiguredSetterMethod method : this.configuredSetterMethods) {
            method.applyValue(instance, true);
        }
        for (ConfigChangeCallbackMethod callback : this.callbackMethods) {
            WeakConfigListenerManager.of().registerConsumer(instance, callback.createConsumer(instance));
        }
    }

    public static boolean isConfigured(Class type) {
        if (type.getAnnotation(org.apache.tamaya.inject.ConfiguredType.class) != null) {
            return true;
        }
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfiguredProperty.class)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(ConfiguredProperty.class)) continue;
            return true;
        }
        return false;
    }

    public Class getType() {
        return this.type;
    }

    public String toString() {
        return "ConfiguredType{" + this.getType().getName() + '}';
    }
}

