/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.internal.InjectionUtils;

public class ConfiguredSetterMethod {
    private Method setterMethod;

    public ConfiguredSetterMethod(Method method) {
        if (Void.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 1) {
            this.setterMethod = method;
        }
    }

    public void applyValue(Object target, boolean resolve) throws ConfigException {
        String configValue = InjectionUtils.getConfigValue(this.setterMethod);
        Objects.requireNonNull(target);
        try {
            String evaluatedString = resolve && configValue != null ? InjectionUtils.evaluateValue(configValue) : configValue;
            Object value = InjectionUtils.adaptValue(this.setterMethod, TypeLiteral.of(this.setterMethod.getParameterTypes()[0]), evaluatedString);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConfiguredSetterMethod.this.setterMethod.setAccessible(true);
                    return ConfiguredSetterMethod.this.setterMethod;
                }
            });
            this.setterMethod.invoke(target, value);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to annotation configured method: " + this.setterMethod.getDeclaringClass().getName() + '.' + this.setterMethod.getName(), (Throwable)e);
        }
    }
}

