/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.DynamicValue;
import org.apache.tamaya.inject.internal.DefaultDynamicValue;
import org.apache.tamaya.inject.internal.InjectionUtils;

public class ConfiguredField {
    private static final Logger LOG = Logger.getLogger(ConfiguredField.class.getName());
    protected Field annotatedField;

    public ConfiguredField(Field field) {
        Objects.requireNonNull(field);
        this.annotatedField = field;
    }

    public void applyValue(Object target) throws ConfigException {
        if (this.annotatedField.getType() == DynamicValue.class) {
            this.applyDynamicValue(target);
        } else {
            this.applyValue(target, false);
        }
    }

    private void applyDynamicValue(Object target) throws ConfigException {
        Objects.requireNonNull(target);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConfiguredField.this.annotatedField.setAccessible(true);
                    return ConfiguredField.this.annotatedField;
                }
            });
            this.annotatedField.set(target, DefaultDynamicValue.of(this.annotatedField, ConfigurationProvider.getConfiguration()));
        }
        catch (Exception e) {
            throw new ConfigException("Failed to annotation configured field: " + this.annotatedField.getDeclaringClass().getName() + '.' + this.annotatedField.getName(), (Throwable)e);
        }
    }

    private void applyValue(Object target, boolean resolve) throws ConfigException {
        Objects.requireNonNull(target);
        try {
            String configValue = InjectionUtils.getConfigValue(this.annotatedField);
            String evaluatedValue = resolve && configValue != null ? InjectionUtils.evaluateValue(configValue) : configValue;
            Object value = InjectionUtils.adaptValue(this.annotatedField, TypeLiteral.of(this.annotatedField.getType()), evaluatedValue);
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ConfiguredField.this.annotatedField.setAccessible(true);
                    return ConfiguredField.this.annotatedField;
                }
            });
            this.annotatedField.set(target, value);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to evaluate annotated field: " + this.annotatedField.getDeclaringClass().getName() + '.' + this.annotatedField.getName(), (Throwable)e);
        }
    }

    public String toString() {
        return "ConfiguredField{" + this.annotatedField.getName() + ": " + " " + this.annotatedField.getAnnotatedType().getType().getTypeName() + '}';
    }
}

