/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.DynamicValue;
import org.apache.tamaya.inject.internal.ConfiguredType;
import org.apache.tamaya.inject.internal.DefaultDynamicValue;
import org.apache.tamaya.inject.internal.InjectionUtils;

public final class ConfigTemplateInvocationHandler
implements InvocationHandler {
    private ConfiguredType type;
    private Configuration configuration;

    public ConfigTemplateInvocationHandler(Class<?> type, Configuration configuration) {
        Objects.requireNonNull(configuration);
        this.type = new ConfiguredType(Objects.requireNonNull(type));
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Can only proxy interfaces as configuration templates.");
        }
        this.configuration = Objects.requireNonNull(configuration);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("toString".equals(method.getName())) {
            return "Configured Proxy -> " + this.type.getType().getName();
        }
        if ("hashCode".equals(method.getName())) {
            return Objects.hashCode(proxy);
        }
        if ("equals".equals(method.getName())) {
            return Objects.equals(proxy, args[0]);
        }
        if ("get".equals(method.getName())) {
            return this.configuration;
        }
        if (method.getReturnType() == DynamicValue.class) {
            return DefaultDynamicValue.of(method, this.configuration);
        }
        String configValue = InjectionUtils.getConfigValue(method);
        Object result = InjectionUtils.adaptValue(method, TypeLiteral.of(method.getReturnType()), configValue);
        if (result == null && method.isDefault()) {
            result = method.getDefaultValue();
        }
        return result;
    }
}

