/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.internal;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.event.PropertyChangeSet;
import org.apache.tamaya.inject.internal.PropertyChangeSetListener;

public final class ConfigChangeCallbackMethod {
    private static final Logger LOG = Logger.getLogger(ConfigChangeCallbackMethod.class.getName());
    private Method callbackMethod;

    public ConfigChangeCallbackMethod(Method methodCandidate) {
        if (Void.TYPE.equals(methodCandidate.getReturnType()) && methodCandidate.getParameterCount() == 1 && methodCandidate.getParameterTypes()[0].equals(PropertyChangeSet.class)) {
            this.callbackMethod = methodCandidate;
        }
    }

    public PropertyChangeSetListener createConsumer(final Object instance) {
        return new PropertyChangeSetListener(){

            @Override
            public void propertyChange(PropertyChangeSet propertyChangeSet) {
                ConfigChangeCallbackMethod.this.call(instance, propertyChangeSet);
            }
        };
    }

    public void call(Object instance, PropertyChangeSet configChangeEvent) {
        try {
            this.callbackMethod.setAccessible(true);
            this.callbackMethod.invoke(instance, configChangeEvent);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error calling ConfigChange callback method " + this.callbackMethod.getDeclaringClass().getName() + '.' + this.callbackMethod.getName() + " on " + instance, e);
        }
    }
}

