/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.event;

import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tamaya.event.PropertyChangeSet;
import org.apache.tamaya.spi.PropertySource;

public final class PropertyChangeSetBuilder {
    final SortedSet<String> addedKeys = new TreeSet<String>();
    final SortedSet<String> updatedKeys = new TreeSet<String>();
    final SortedSet<String> removedKeys = new TreeSet<String>();
    String propertySourceName;

    private PropertyChangeSetBuilder(PropertySource source) {
        this.propertySourceName = Objects.requireNonNull(source).getName();
    }

    public static PropertyChangeSetBuilder of(PropertySource source) {
        return new PropertyChangeSetBuilder(source);
    }

    public PropertyChangeSetBuilder remove(String ... keys) {
        for (String removeKey : keys) {
            this.removedKeys.add(removeKey);
        }
        return this;
    }

    public PropertyChangeSetBuilder add(String ... keys) {
        for (String addKey : keys) {
            this.addedKeys.add(addKey);
        }
        return this;
    }

    public PropertyChangeSetBuilder update(String ... keys) {
        for (String uptKey : keys) {
            this.updatedKeys.add(uptKey);
        }
        return this;
    }

    public PropertyChangeSetBuilder addChanges(Map<String, String> map1, Map<String, String> map2) {
        String val;
        for (Map.Entry<String, String> en : map1.entrySet()) {
            val = map2.get(en.getKey());
            if (val == null) {
                this.remove(en.getKey());
                continue;
            }
            if (val.equals(en.getValue())) continue;
            this.update(en.getKey());
        }
        for (Map.Entry<String, String> en : map2.entrySet()) {
            val = map1.get(en.getKey());
            if (val != null) continue;
            this.add(en.getKey());
        }
        return this;
    }

    public PropertyChangeSet build() {
        return new PropertyChangeSet(this);
    }

    public String toString() {
        return "PropertyChangeEventBuilder [propertySourceName=" + this.propertySourceName + ", " + ", added=" + this.addedKeys + ", updated=" + this.updatedKeys + ", removed=" + this.removedKeys + "]";
    }
}

