/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.event;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tamaya.event.PropertyChangeSetBuilder;

public final class PropertyChangeSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String propertySourceName;
    private long timestamp = System.currentTimeMillis();
    final SortedSet<String> addedKeys = new TreeSet<String>();
    final SortedSet<String> updatedKeys = new TreeSet<String>();
    final SortedSet<String> removedKeys = new TreeSet<String>();

    PropertyChangeSet(PropertyChangeSetBuilder builder) {
        this.propertySourceName = Objects.requireNonNull(builder.propertySourceName);
        this.addedKeys.addAll(builder.addedKeys);
        this.removedKeys.addAll(builder.removedKeys);
        this.updatedKeys.addAll(builder.updatedKeys);
    }

    public String getPropertySourceName() {
        return this.propertySourceName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Collection<String> getKeysAdded() {
        return Collections.unmodifiableCollection(this.addedKeys);
    }

    public Collection<String> getKeysRemoved() {
        return Collections.unmodifiableCollection(this.removedKeys);
    }

    public Collection<String> getKeysUpdated() {
        return Collections.unmodifiableCollection(this.addedKeys);
    }

    public boolean isEmpty() {
        return this.addedKeys.isEmpty() && this.updatedKeys.isEmpty() && this.removedKeys.isEmpty();
    }

    public String toString() {
        return "ConfigChangeSet{propertySourceName=" + this.propertySourceName + ", timestamp=" + this.timestamp + ", addedKeys=" + this.addedKeys + ", updatedKeys=" + this.updatedKeys + ", removedKeys=" + this.removedKeys + '}';
    }
}

