/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya;

import org.apache.tamaya.Configuration;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.ConfigurationProviderSpi;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ConfigurationProvider {
    private static final ConfigurationProviderSpi PROVIDER_SPI = ConfigurationProvider.loadSpi();

    private static ConfigurationProviderSpi loadSpi() {
        ConfigurationProviderSpi spi = ServiceContextManager.getServiceContext().getService(ConfigurationProviderSpi.class);
        if (spi == null) {
            throw new IllegalStateException("ConfigurationProviderSpi not available.");
        }
        return spi;
    }

    private ConfigurationProvider() {
    }

    public static Configuration getConfiguration() {
        return PROVIDER_SPI.getConfiguration();
    }

    public static ConfigurationContext getConfigurationContext() {
        return PROVIDER_SPI.getConfigurationContext();
    }

    public static void setConfigurationContext(ConfigurationContext context) {
        PROVIDER_SPI.setConfigurationContext(context);
    }

    public static ConfigurationContextBuilder getConfigurationContextBuilder() {
        return PROVIDER_SPI.getConfigurationContextBuilder();
    }
}

