/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.builder.SimplePropertySource;
import org.apache.tamaya.spi.PropertySource;

public final class PropertySourceBuilder {
    private int ordinal;
    private String name;
    private Map<String, String> properties = new HashMap<String, String>();

    private PropertySourceBuilder(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public static PropertySourceBuilder of(String name) {
        return new PropertySourceBuilder(name);
    }

    public static PropertySourceBuilder from(String name) {
        return new PropertySourceBuilder(name);
    }

    public PropertySourceBuilder put(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public PropertySourceBuilder putAll(Map<String, String> values) {
        this.properties.putAll(values);
        return this;
    }

    public PropertySourceBuilder withOrdinal(int ordinal) {
        this.ordinal = ordinal;
        return this;
    }

    public PropertySourceBuilder putAll(PropertySource propertySource) {
        this.properties.putAll(propertySource.getProperties());
        return this;
    }

    public PropertySource build() {
        return new SimplePropertySource(this.name, this.properties);
    }

    public String toString() {
        return "PropertySourceBuilder{ordinal=" + this.ordinal + ", name='" + this.name + '\'' + ", properties=" + this.properties + '}';
    }
}

