/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.core.internal.PropertyConverterManager;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;
import org.apache.tamaya.spi.ServiceContext;

class ProgrammaticConfigurationContext
implements ConfigurationContext {
    private static final Logger LOG = Logger.getLogger(ProgrammaticConfigurationContext.class.getName());
    private PropertyConverterManager propertyConverterManager = new PropertyConverterManager();
    private List<PropertySource> immutablePropertySources = new ArrayList<PropertySource>();
    private List<PropertyFilter> immutablePropertyFilters = new ArrayList<PropertyFilter>();
    private PropertyValueCombinationPolicy propertyValueCombinationPolicy;
    private StampedLock propertySourceLock = new StampedLock();

    public ProgrammaticConfigurationContext(Builder builder) {
        this.propertyConverterManager = new PropertyConverterManager(builder.loadProvidedPropertyConverters);
        this.immutablePropertySources = this.getAllPropertySources(builder).stream().sorted(this::comparePropertySources).collect(Collectors.toList());
        this.immutablePropertyFilters = this.getPropertyFilters(builder).stream().sorted(this::comparePropertyFilters).collect(Collectors.toList());
        this.propertyValueCombinationPolicy = builder.propertyValueCombinationPolicy;
        builder.propertyConverters.forEach((literal, converters) -> converters.stream().filter(c -> c != null).forEach(c -> this.propertyConverterManager.register(literal, c)));
        LOG.info(() -> "Using " + this.immutablePropertySources.size() + " property sources: " + this.createStringList(this.immutablePropertySources, ps -> ps.getName() + '[' + ps.getClass().getName() + ']'));
        LOG.info(() -> "Using " + this.immutablePropertyFilters.size() + " property filters: " + this.createStringList(this.immutablePropertyFilters, f -> f.getClass().getName()));
        LOG.info(() -> "Using PropertyValueCombinationPolicy: " + this.propertyValueCombinationPolicy);
    }

    private List<PropertyFilter> getPropertyFilters(Builder builder) {
        List provided = builder.loadProvidedPropertyFilters ? ServiceContext.getInstance().getServices(PropertyFilter.class) : new ArrayList(0);
        List configured = builder.propertyFilters;
        return Stream.of(provided, configured).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<PropertySource> getAllPropertySources(Builder builder) {
        List provided;
        List list = provided = builder.loadProvidedPropertySources ? ServiceContext.getInstance().getServices(PropertySource.class) : new ArrayList(0);
        if (builder.loadProvidedPropertySourceProviders) {
            List providers = ServiceContext.getInstance().getServices(PropertySourceProvider.class);
            for (PropertySourceProvider provider : providers) {
                Collection sources = provider.getPropertySources();
                provided.addAll(sources);
            }
        }
        List configured = builder.propertySources;
        return Stream.of(provided, configured).flatMap(Collection::stream).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertySources(PropertySource ... propertySourcesToAdd) {
        Lock writeLock = this.propertySourceLock.asWriteLock();
        try {
            writeLock.lock();
            ArrayList<PropertySource> newPropertySources = new ArrayList<PropertySource>(this.immutablePropertySources);
            newPropertySources.addAll(Arrays.asList(propertySourcesToAdd));
            Collections.sort(newPropertySources, this::comparePropertySources);
            this.immutablePropertySources = Collections.unmodifiableList(newPropertySources);
        }
        finally {
            writeLock.unlock();
        }
    }

    private int comparePropertySources(PropertySource source1, PropertySource source2) {
        if (source1.getOrdinal() < source2.getOrdinal()) {
            return -1;
        }
        if (source1.getOrdinal() > source2.getOrdinal()) {
            return 1;
        }
        return source1.getClass().getName().compareTo(source2.getClass().getName());
    }

    private int comparePropertyFilters(PropertyFilter filter1, PropertyFilter filter2) {
        int ord2;
        Priority prio1 = filter1.getClass().getAnnotation(Priority.class);
        Priority prio2 = filter2.getClass().getAnnotation(Priority.class);
        int ord1 = prio1 != null ? prio1.value() : 0;
        int n = ord2 = prio2 != null ? prio2.value() : 0;
        if (ord1 < ord2) {
            return -1;
        }
        if (ord1 > ord2) {
            return 1;
        }
        return filter1.getClass().getName().compareTo(filter2.getClass().getName());
    }

    public List<PropertySource> getPropertySources() {
        return this.immutablePropertySources;
    }

    public <T> void addPropertyConverter(TypeLiteral<T> typeToConvert, PropertyConverter<T> propertyConverter) {
        this.propertyConverterManager.register(typeToConvert, propertyConverter);
        LOG.info(() -> "Added PropertyConverter: " + propertyConverter.getClass().getName());
    }

    public Map<TypeLiteral<?>, List<PropertyConverter<?>>> getPropertyConverters() {
        return this.propertyConverterManager.getPropertyConverters();
    }

    public <T> List<PropertyConverter<T>> getPropertyConverters(TypeLiteral<T> targetType) {
        return this.propertyConverterManager.getPropertyConverters(targetType);
    }

    public List<PropertyFilter> getPropertyFilters() {
        return this.immutablePropertyFilters;
    }

    public PropertyValueCombinationPolicy getPropertyValueCombinationPolicy() {
        return this.propertyValueCombinationPolicy;
    }

    private <T> String createStringList(Collection<T> propertySources, Function<T, String> mapper) {
        StringJoiner joiner = new StringJoiner(", ");
        propertySources.forEach(t -> joiner.add((CharSequence)mapper.apply(t)));
        return joiner.toString();
    }

    public ConfigurationContextBuilder toBuilder() {
        throw new RuntimeException("This method is currently not supported.");
    }

    public Collection<PropertySource> getPropertySources(Predicate<PropertySource> selector) {
        throw new RuntimeException("This method is currently not supported.");
    }

    public static final class Builder {
        private List<PropertySource> propertySources = new ArrayList<PropertySource>();
        private List<PropertyFilter> propertyFilters = new ArrayList<PropertyFilter>();
        private Map<TypeLiteral<?>, List<PropertyConverter<?>>> propertyConverters = new HashMap();
        private PropertyValueCombinationPolicy propertyValueCombinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
        private boolean loadProvidedPropertyConverters;
        private boolean loadProvidedPropertySources;
        private boolean loadProvidedPropertySourceProviders;
        private boolean loadProvidedPropertyFilters;

        public Builder setPropertyValueCombinationPolicy(PropertyValueCombinationPolicy policy) {
            this.propertyValueCombinationPolicy = Objects.requireNonNull(policy);
            return this;
        }

        public Builder addPropertySources(PropertySource ... propertySources) {
            List filtered = Stream.of(propertySources).filter(this::isNotNull).collect(Collectors.toList());
            this.propertySources.addAll(filtered);
            return this;
        }

        public Builder addPropertySources(Collection<PropertySource> propertySources) {
            List filtered = propertySources.stream().filter(this::isNotNull).collect(Collectors.toList());
            this.propertySources.addAll(filtered);
            return this;
        }

        public Builder addPropertySourceProviders(PropertySourceProvider ... propertySourceProviders) {
            List<PropertySourceProvider> providers = Stream.of(propertySourceProviders).filter(this::isNotNull).collect(Collectors.toList());
            return this.addPropertySourceProviders(providers);
        }

        public Builder addPropertySourceProviders(Collection<PropertySourceProvider> providers) {
            List filtered = providers.stream().filter(this::isNotNull).flatMap(p -> p.getPropertySources().stream()).filter(this::isNotNull).collect(Collectors.toList());
            this.propertySources.addAll(filtered);
            return this;
        }

        public Builder addPropertyFilters(PropertyFilter ... propertySources) {
            List sources = Stream.of(propertySources).filter(this::isNotNull).collect(Collectors.toList());
            this.propertyFilters.addAll(sources);
            return this;
        }

        public Builder addPropertyFilters(Collection<PropertyFilter> propertySources) {
            List sources = propertySources.stream().filter(this::isNotNull).collect(Collectors.toList());
            this.propertyFilters.addAll(sources);
            return this;
        }

        @Deprecated
        public Builder setConfigurationContext(ConfigurationContext configurationContext) {
            this.addPropertySources(configurationContext.getPropertySources());
            this.addPropertyFilters(configurationContext.getPropertyFilters());
            this.propertyValueCombinationPolicy = Objects.requireNonNull(configurationContext.getPropertyValueCombinationPolicy());
            return this;
        }

        public <T> Builder addPropertyConverter(TypeLiteral<T> type, PropertyConverter<T> propertyConverter) {
            this.propertyConverters.computeIfAbsent(type, t -> new ArrayList()).add(propertyConverter);
            return this;
        }

        public ConfigurationContext build() {
            return new ProgrammaticConfigurationContext(this);
        }

        public void loadProvidedPropertyConverters(boolean state) {
            this.loadProvidedPropertyConverters = state;
        }

        public void loadProvidedPropertySources(boolean state) {
            this.loadProvidedPropertySources = state;
        }

        public void loadProvidedPropertySourceProviders(boolean state) {
            this.loadProvidedPropertySourceProviders = state;
        }

        public void loadProvidedPropertyFilters(boolean state) {
            this.loadProvidedPropertyFilters = state;
        }

        private <T> boolean isNotNull(T item) {
            return null != item;
        }
    }
}

