/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.propertysource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tamaya.spi.PropertySource;

public class SystemPropertySource
implements PropertySource {
    public static final int DEFAULT_ORDINAL = 1000;
    private volatile Map<String, String> cachedProperties = this.loadProperties();
    private int previousHash = System.getProperties().hashCode();

    private Map<String, String> loadProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Properties sysProps = System.getProperties();
        for (String name : sysProps.stringPropertyNames()) {
            props.put(name, sysProps.getProperty(name));
        }
        return props;
    }

    public int getOrdinal() {
        return 1000;
    }

    public String getName() {
        return "system-properties";
    }

    public String get(String key) {
        return this.getProperties().get(key);
    }

    public Map<String, String> getProperties() {
        if (this.previousHash != System.getProperties().hashCode()) {
            Map<String, String> properties = this.loadProperties();
            this.cachedProperties = Collections.unmodifiableMap(properties);
            this.previousHash = System.getProperties().hashCode();
        }
        return this.cachedProperties;
    }

    public boolean isScannable() {
        return true;
    }
}

