/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.spi.PropertyConverter;

public class ShortConverter
implements PropertyConverter<Short> {
    private static final Logger LOG = Logger.getLogger(ShortConverter.class.getName());

    public Short convert(String value) {
        String trimmed = Objects.requireNonNull(value).trim();
        switch (trimmed.toUpperCase(Locale.ENGLISH)) {
            case "MIN_VALUE": 
            case "MIN": {
                return (short)Short.MIN_VALUE;
            }
            case "MAX_VALUE": 
            case "MAX": {
                return (short)Short.MAX_VALUE;
            }
        }
        try {
            return Short.decode(trimmed);
        }
        catch (Exception e) {
            LOG.finest("Unparseable Short: " + trimmed);
            return null;
        }
    }
}

