/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.spi.PropertyConverter;

public class EnumConverter<T>
implements PropertyConverter<T> {
    private Logger LOG = Logger.getLogger(EnumConverter.class.getName());
    private Class<T> enumType;
    private Method factory;

    public EnumConverter(Class<T> enumType) {
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new IllegalArgumentException("Not an Enum: " + enumType.getName());
        }
        this.enumType = Objects.requireNonNull(enumType);
        try {
            this.factory = enumType.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigException("Uncovertible enum type without valueOf method found, please provide a custom PropertyConverter for: " + enumType.getName());
        }
    }

    public T convert(String value) {
        try {
            return (T)this.factory.invoke(null, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.LOG.log(Level.FINEST, "Invalid enum value '" + value + "' for " + this.enumType.getName(), e);
            try {
                return (T)this.factory.invoke(null, value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                this.LOG.log(Level.FINEST, "Invalid enum value '" + value + "' for " + this.enumType.getName(), e2);
                return null;
            }
        }
    }
}

