/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.spi.PropertyConverter;

public class ClassConverter
implements PropertyConverter<Class<?>> {
    private Logger LOG = Logger.getLogger(this.getClass().getName());

    public Class<?> convert(String value) {
        String trimmed = Objects.requireNonNull(value).trim();
        try {
            return Class.forName(trimmed, false, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            this.LOG.finest("Class not found in context CL: " + trimmed);
            try {
                return Class.forName(trimmed, false, ClassConverter.class.getClassLoader());
            }
            catch (Exception e2) {
                this.LOG.finest("Class not found in ClassConverter's CL: " + trimmed);
                try {
                    return Class.forName(trimmed, false, ClassLoader.getSystemClassLoader());
                }
                catch (Exception e3) {
                    this.LOG.finest("Class not found in System CL (giving up): " + trimmed);
                    return null;
                }
            }
        }
    }
}

