/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.core.internal.DefaultServiceContext;
import org.apache.tamaya.core.internal.converters.EnumConverter;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.ServiceContextManager;

public class PropertyConverterManager {
    private static final Logger LOG = Logger.getLogger(PropertyConverterManager.class.getName());
    private Map<TypeLiteral<?>, List<PropertyConverter<?>>> converters = new ConcurrentHashMap();
    private Map<TypeLiteral<?>, List<PropertyConverter<?>>> transitiveConverters = new ConcurrentHashMap();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Comparator<Object> PRIORITY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int prio = DefaultServiceContext.getPriority(o1) - DefaultServiceContext.getPriority(o2);
            if (prio < 0) {
                return 1;
            }
            if (prio > 0) {
                return -1;
            }
            return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
        }
    };

    public PropertyConverterManager() {
        this(true);
    }

    public PropertyConverterManager(boolean init) {
        if (init) {
            this.initConverters();
        }
    }

    protected void initConverters() {
        for (PropertyConverter conv : ServiceContextManager.getServiceContext().getServices(PropertyConverter.class)) {
            Type type = TypeLiteral.getGenericInterfaceTypeParameters(conv.getClass(), PropertyConverter.class)[0];
            this.register(TypeLiteral.of((Type)type), conv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(TypeLiteral<T> targetType, PropertyConverter<T> converter) {
        Objects.requireNonNull(converter);
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            List converters = (List)List.class.cast(this.converters.get(targetType));
            ArrayList<PropertyConverter<T>> newConverters = new ArrayList<PropertyConverter<T>>();
            if (converters != null) {
                newConverters.addAll(converters);
            }
            newConverters.add(converter);
            Collections.sort(newConverters, PRIORITY_COMPARATOR);
            this.converters.put(targetType, Collections.unmodifiableList(newConverters));
            for (Class<?> ifaceType : targetType.getRawType().getInterfaces()) {
                converters = (List)List.class.cast(this.transitiveConverters.get(ifaceType));
                newConverters = new ArrayList();
                if (converters != null) {
                    newConverters.addAll(converters);
                }
                newConverters.add(converter);
                Collections.sort(newConverters, PRIORITY_COMPARATOR);
                this.transitiveConverters.put(TypeLiteral.of(ifaceType), Collections.unmodifiableList(newConverters));
            }
            for (Class superClass = targetType.getRawType().getSuperclass(); superClass != null && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
                converters = (List)List.class.cast(this.transitiveConverters.get(superClass));
                newConverters = new ArrayList();
                if (converters != null) {
                    newConverters.addAll(converters);
                }
                newConverters.add(converter);
                Collections.sort(newConverters, PRIORITY_COMPARATOR);
                this.transitiveConverters.put(TypeLiteral.of(superClass), Collections.unmodifiableList(newConverters));
                for (Class<?> ifaceType : superClass.getInterfaces()) {
                    converters = (List)List.class.cast(this.transitiveConverters.get(ifaceType));
                    newConverters = new ArrayList();
                    if (converters != null) {
                        newConverters.addAll(converters);
                    }
                    newConverters.add(converter);
                    Collections.sort(newConverters, PRIORITY_COMPARATOR);
                    this.transitiveConverters.put(TypeLiteral.of(ifaceType), Collections.unmodifiableList(newConverters));
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean isTargetTypeSupported(TypeLiteral<?> targetType) {
        if (this.converters.containsKey(targetType) || this.transitiveConverters.containsKey(targetType)) {
            return true;
        }
        return this.createDefaultPropertyConverter(targetType) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TypeLiteral<?>, List<PropertyConverter<?>>> getPropertyConverters() {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            HashMap hashMap = new HashMap(this.converters);
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<PropertyConverter<T>> getPropertyConverters(TypeLiteral<T> targetType) {
        TypeLiteral<T> boxedType;
        List converters;
        Lock readLock = this.lock.readLock();
        ArrayList<PropertyConverter<T>> converterList = new ArrayList<PropertyConverter<T>>();
        try {
            readLock.lock();
            converters = (List)List.class.cast(this.converters.get(targetType));
        }
        finally {
            readLock.unlock();
        }
        if (converters != null) {
            converterList.addAll(converters);
        }
        try {
            readLock.lock();
            converters = (List)List.class.cast(this.transitiveConverters.get(targetType));
        }
        finally {
            readLock.unlock();
        }
        if (converters != null) {
            converterList.addAll(converters);
        }
        if ((boxedType = this.mapBoxedType(targetType)) != null) {
            try {
                readLock.lock();
                converters = (List)List.class.cast(this.converters.get(boxedType));
            }
            finally {
                readLock.unlock();
            }
            if (converters != null) {
                converterList.addAll(converters);
            }
        }
        if (converterList.isEmpty()) {
            PropertyConverter<T> defaultConverter = this.createDefaultPropertyConverter(targetType);
            if (defaultConverter != null) {
                this.register(targetType, defaultConverter);
                try {
                    readLock.lock();
                    converters = (List)List.class.cast(this.converters.get(targetType));
                }
                finally {
                    readLock.unlock();
                }
            }
            if (converters != null) {
                converterList.addAll(converters);
            }
        }
        return converterList;
    }

    private <T> TypeLiteral<T> mapBoxedType(TypeLiteral<T> targetType) {
        Type parameterType = targetType.getType();
        if (parameterType == Integer.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Integer.class));
        }
        if (parameterType == Short.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Short.class));
        }
        if (parameterType == Byte.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Byte.class));
        }
        if (parameterType == Long.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Long.class));
        }
        if (parameterType == Boolean.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Boolean.class));
        }
        if (parameterType == Character.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Character.class));
        }
        if (parameterType == Float.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Float.class));
        }
        if (parameterType == Double.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Double.class));
        }
        if (parameterType == int[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Integer[].class));
        }
        if (parameterType == short[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Short[].class));
        }
        if (parameterType == byte[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Byte[].class));
        }
        if (parameterType == long[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Long[].class));
        }
        if (parameterType == Boolean.TYPE) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Boolean.class));
        }
        if (parameterType == char[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Character[].class));
        }
        if (parameterType == float[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Float[].class));
        }
        if (parameterType == double[].class) {
            return (TypeLiteral)TypeLiteral.class.cast(TypeLiteral.of(Double[].class));
        }
        return null;
    }

    protected <T> PropertyConverter<T> createDefaultPropertyConverter(final TypeLiteral<T> targetType) {
        if (Enum.class.isAssignableFrom(targetType.getRawType())) {
            return new EnumConverter(targetType.getRawType());
        }
        Object converter = null;
        final Method factoryMethod = this.getFactoryMethod(targetType.getRawType(), "of", "valueOf", "instanceOf", "getInstance", "from", "fromString", "parse");
        if (factoryMethod != null) {
            converter = new PropertyConverter<T>(){

                public T convert(String value) {
                    try {
                        if (!Modifier.isStatic(factoryMethod.getModifiers())) {
                            throw new ConfigException(factoryMethod.toGenericString() + " is not a static method. Only static " + "methods can be used as factory methods.");
                        }
                        factoryMethod.setAccessible(true);
                        Object invoke = factoryMethod.invoke(null, value);
                        return targetType.getRawType().cast(invoke);
                    }
                    catch (Exception e) {
                        throw new ConfigException("Failed to decode '" + value + "'", (Throwable)e);
                    }
                }
            };
        }
        if (converter == null) {
            try {
                final Constructor constr = targetType.getRawType().getDeclaredConstructor(String.class);
                converter = new PropertyConverter<T>(){

                    public T convert(String value) {
                        try {
                            constr.setAccessible(true);
                            return constr.newInstance(value);
                        }
                        catch (Exception e) {
                            throw new ConfigException("Failed to decode '" + value + "'", (Throwable)e);
                        }
                    }
                };
            }
            catch (Exception e) {
                LOG.finest("Failed to construct instance of type: " + targetType.getRawType().getName() + ": " + e);
            }
        }
        return converter;
    }

    private Method getFactoryMethod(Class<?> type, String ... methodNames) {
        for (String name : methodNames) {
            try {
                Method m = type.getDeclaredMethod(name, String.class);
                return m;
            }
            catch (NoSuchMethodException | RuntimeException e) {
                LOG.finest("No such factory method found on type: " + type.getName() + ", methodName: " + name);
            }
        }
        return null;
    }
}

