/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.core.internal.DefaultConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;

public class DefaultConfigurationContextBuilder
implements ConfigurationContextBuilder {
    Map<String, PropertySource> propertySources = new HashMap<String, PropertySource>();
    List<PropertyFilter> propertyFilters = new ArrayList<PropertyFilter>();
    Map<TypeLiteral<?>, List<PropertyConverter<?>>> propertyConverters = new HashMap();
    PropertyValueCombinationPolicy combinationPolicy;

    public ConfigurationContextBuilder setContext(ConfigurationContext context) {
        this.propertySources.clear();
        for (PropertySource ps : context.getPropertySources()) {
            this.propertySources.put(ps.getName(), ps);
        }
        this.propertyFilters.clear();
        this.propertyFilters.addAll(context.getPropertyFilters());
        this.propertyConverters.clear();
        this.propertyConverters.putAll(context.getPropertyConverters());
        this.combinationPolicy = context.getPropertyValueCombinationPolicy();
        return this;
    }

    public ConfigurationContextBuilder addPropertySources(Collection<PropertySource> propertySourcesToAdd) {
        for (PropertySource ps : propertySourcesToAdd) {
            if (!this.propertySources.containsKey(ps.getName())) continue;
            throw new ConfigException("Duplicate PropertySource: " + ps.getName());
        }
        for (PropertySource ps : propertySourcesToAdd) {
            this.propertySources.put(ps.getName(), ps);
        }
        return this;
    }

    public ConfigurationContextBuilder addPropertySources(PropertySource ... propertySourcesToAdd) {
        return this.addPropertySources(Arrays.asList(propertySourcesToAdd));
    }

    public ConfigurationContextBuilder removePropertySources(Collection<String> propertySourcesToRemove) {
        for (String key : propertySourcesToRemove) {
            this.propertySources.remove(key);
        }
        return this;
    }

    public ConfigurationContextBuilder removePropertySources(String ... propertySourcesToRemove) {
        return this.removePropertySources(Arrays.asList(propertySourcesToRemove));
    }

    public ConfigurationContextBuilder addPropertyFilters(Collection<PropertyFilter> filters) {
        this.propertyFilters.addAll(filters);
        return this;
    }

    public ConfigurationContextBuilder addPropertyFilters(PropertyFilter ... filters) {
        return this.addPropertyFilters(Arrays.asList(filters));
    }

    public ConfigurationContextBuilder removePropertyFilters(Collection<PropertyFilter> filters) {
        this.propertyFilters.removeAll(filters);
        return this;
    }

    public ConfigurationContextBuilder removePropertyFilters(PropertyFilter ... filters) {
        return this.removePropertyFilters(Arrays.asList(filters));
    }

    public <T> ConfigurationContextBuilder addPropertyConverter(TypeLiteral<T> typeToConvert, PropertyConverter<T> propertyConverter) {
        List<PropertyConverter<?>> converters = this.propertyConverters.get(typeToConvert);
        if (converters == null) {
            converters = new ArrayList();
            this.propertyConverters.put(typeToConvert, converters);
        }
        return this;
    }

    public ConfigurationContextBuilder removePropertyConverters(TypeLiteral<?> typeToConvert, PropertyConverter<?> ... converters) {
        return this.removePropertyConverters(typeToConvert, Arrays.asList(converters));
    }

    public ConfigurationContextBuilder removePropertyConverters(TypeLiteral<?> typeToConvert, Collection<PropertyConverter<?>> converters) {
        List<PropertyConverter<PropertyConverter<?>>> existing = this.propertyConverters.get(typeToConvert);
        if (existing != null) {
            existing.removeAll(converters);
        }
        return this;
    }

    public ConfigurationContextBuilder setPropertyValueCombinationPolicy(PropertyValueCombinationPolicy policy) {
        this.combinationPolicy = Objects.requireNonNull(policy);
        return this;
    }

    public ConfigurationContext build() {
        return new DefaultConfigurationContext(this);
    }
}

