/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;

public class DefaultConfiguration
implements Configuration {
    private static final Logger LOG = Logger.getLogger(DefaultConfiguration.class.getName());
    private static final int MAX_FILTER_LOOPS = 10;
    private final ConfigurationContext configurationContext;

    public DefaultConfiguration(ConfigurationContext configurationContext) {
        this.configurationContext = Objects.requireNonNull(configurationContext);
    }

    public String get(String key) {
        List propertySources = this.configurationContext.getPropertySources();
        String unfilteredValue = null;
        PropertyValueCombinationPolicy combinationPolicy = this.configurationContext.getPropertyValueCombinationPolicy();
        for (PropertySource propertySource : propertySources) {
            unfilteredValue = combinationPolicy.collect(unfilteredValue, key, propertySource);
        }
        return this.applyFilter(key, unfilteredValue);
    }

    private String applyFilter(String key, String unfilteredValue) {
        for (int i = 0; i < 10; ++i) {
            boolean changed = false;
            for (PropertyFilter filter : this.configurationContext.getPropertyFilters()) {
                String newValue = filter.filterProperty(key, unfilteredValue);
                if (newValue != null && !newValue.equals(unfilteredValue)) {
                    changed = true;
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Filter - " + key + ": " + unfilteredValue + " -> " + newValue + " by " + filter);
                    }
                } else if (unfilteredValue != null && !unfilteredValue.equals(newValue)) {
                    changed = true;
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Filter - " + key + ": " + unfilteredValue + " -> " + newValue + " by " + filter);
                    }
                }
                unfilteredValue = newValue;
            }
            if (!changed) {
                LOG.finest("Finishing filter loop, no changes detected.");
                break;
            }
            if (i == 9) {
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Maximal filter loop count reached, aborting filter evaluation after cycles: " + i);
                continue;
            }
            LOG.finest("Repeating filter loop, changes detected.");
        }
        return unfilteredValue;
    }

    public Map<String, String> getProperties() {
        ArrayList propertySources = new ArrayList(this.configurationContext.getPropertySources());
        Collections.reverse(propertySources);
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertySource propertySource : propertySources) {
            try {
                int origSize = result.size();
                Map otherMap = propertySource.getProperties();
                LOG.log(Level.FINEST, null, "Overriding with properties from " + propertySource.getName());
                result.putAll(otherMap);
                LOG.log(Level.FINEST, null, "Handled properties from " + propertySource.getName() + "(new: " + (result.size() - origSize) + ", overrides: " + origSize + ", total: " + result.size());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error adding properties from PropertySource: " + propertySource + ", ignoring PropertySource.", e);
            }
        }
        return this.applyFilters(result);
    }

    private Map<String, String> applyFilters(Map<String, String> inputMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>(inputMap);
        for (int i = 0; i < 10; ++i) {
            AtomicInteger changes = new AtomicInteger();
            for (PropertyFilter filter : this.configurationContext.getPropertyFilters()) {
                for (Map.Entry<String, String> entry : inputMap.entrySet()) {
                    String v;
                    String k = entry.getKey();
                    String newValue = filter.filterProperty(k, v = entry.getValue());
                    if (newValue != null && !newValue.equals(v)) {
                        changes.incrementAndGet();
                        LOG.finest("Filter - " + k + ": " + v + " -> " + newValue + " by " + filter);
                    } else if (v != null && !v.equals(newValue)) {
                        changes.incrementAndGet();
                        LOG.finest("Filter - " + k + ": " + v + " -> " + newValue + " by " + filter);
                    }
                    if (null != newValue) {
                        resultMap.put(k, newValue);
                        continue;
                    }
                    resultMap.remove(k);
                }
            }
            if (changes.get() == 0) {
                LOG.finest("Finishing filter loop, no changes detected.");
                break;
            }
            if (i == 9) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Maximal filter loop count reached, aborting filter evaluation after cycles: " + i);
                }
            } else {
                LOG.finest("Repeating filter loop, changes detected: " + changes.get());
            }
            changes.set(0);
        }
        return resultMap;
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, TypeLiteral.of(type));
    }

    public <T> T get(String key, TypeLiteral<T> type) {
        String value = this.get(key);
        if (value != null) {
            List converters = this.configurationContext.getPropertyConverters(type);
            for (PropertyConverter converter : converters) {
                try {
                    Object t = converter.convert(value);
                    if (t == null) continue;
                    return (T)t;
                }
                catch (Exception e) {
                    LOG.log(Level.FINEST, "PropertyConverter: " + converter + " failed to convert value: " + value, e);
                }
            }
            throw new ConfigException("Unparseable config value for type: " + type.getRawType().getName() + ": " + key);
        }
        return null;
    }

    public Configuration with(ConfigOperator operator) {
        return operator.operate((Configuration)this);
    }

    public <T> T query(ConfigQuery<T> query) {
        return (T)query.query((Configuration)this);
    }
}

