/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.resource.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.resource.BaseResourceResolver;
import org.apache.tamaya.resource.internal.ClasspathCollector;
import org.apache.tamaya.resource.internal.FileCollector;

@Priority(value=0)
public class DefaultResourceResolver
extends BaseResourceResolver {
    private static final Logger LOG = Logger.getLogger(DefaultResourceResolver.class.getName());

    public List<URL> getResources(ClassLoader classLoader, Collection<String> expressions) {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (String expression : expressions) {
            if (this.tryPath(classLoader, expression, resources) || this.tryClassPath(classLoader, expression, resources) || this.tryFile(expression, resources) || this.tryURL(expression, resources)) continue;
            LOG.warning("Failed to resolve resource: " + expression);
        }
        return resources;
    }

    private boolean tryPath(ClassLoader classLoader, String expression, List<URL> resources) {
        try {
            Collection<URL> found = FileCollector.collectFiles(expression);
            if (found.isEmpty()) {
                found = new ClasspathCollector(classLoader).collectFiles(expression);
            }
            resources.addAll(found);
            return !found.isEmpty();
        }
        catch (RuntimeException e) {
            LOG.finest("Failed to load resource from CP: " + expression);
            return false;
        }
    }

    private boolean tryClassPath(ClassLoader classLoader, String expression, List<URL> resources) {
        try {
            Enumeration<URL> urls = classLoader.getResources(expression);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                resources.add(url);
            }
            return !resources.isEmpty();
        }
        catch (IOException | RuntimeException e) {
            LOG.finest("Failed to load resource from CP: " + expression);
            return false;
        }
    }

    private boolean tryFile(String expression, List<URL> resources) {
        try {
            File file = new File(expression);
            if (file.exists()) {
                resources.add(file.toURI().toURL());
                return true;
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.finest("Failed to load resource from file: " + expression);
        }
        return false;
    }

    private boolean tryURL(String expression, List<URL> resources) {
        try {
            URL url = new URL(expression);
            resources.add(url);
            return true;
        }
        catch (IOException | RuntimeException e) {
            LOG.finest("Failed to load resource from file: " + expression);
            return false;
        }
    }
}

