/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format.formats;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationDataBuilder;
import org.apache.tamaya.format.ConfigurationFormat;

public class PropertiesXmlFormat
implements ConfigurationFormat {
    private static final Logger LOG = Logger.getLogger(PropertiesXmlFormat.class.getName());

    @Override
    public String getName() {
        return "xml-properties";
    }

    @Override
    public boolean accepts(URL url) {
        String fileName = url.getFile();
        return fileName.endsWith(".xml") || fileName.endsWith(".XML");
    }

    @Override
    public ConfigurationData readConfiguration(String resource, InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(resource);
        try {
            Properties p = new Properties();
            p.loadFromXML(inputStream);
            return ConfigurationDataBuilder.of(resource, this).addProperties((Map)Map.class.cast(p)).build();
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, "Failed to read config from resource: " + resource, e);
            return null;
        }
    }
}

