/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format.formats;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationDataBuilder;
import org.apache.tamaya.format.ConfigurationFormat;

public class IniConfigurationFormat
implements ConfigurationFormat {
    private static final Logger LOG = Logger.getLogger(IniConfigurationFormat.class.getName());

    @Override
    public String getName() {
        return "ini";
    }

    @Override
    public boolean accepts(URL url) {
        String fileName = url.getFile();
        return fileName.endsWith(".ini") || fileName.endsWith(".INI");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigurationData readConfiguration(String resource, InputStream inputStream) {
        ConfigurationDataBuilder builder = ConfigurationDataBuilder.of(resource, this);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String line = reader.readLine();
            int lineNum = 0;
            String section = null;
            while (line != null) {
                ++lineNum;
                if ((line = line.trim()).isEmpty()) {
                    line = reader.readLine();
                    continue;
                }
                if (line.startsWith("[")) {
                    int end = line.indexOf(93);
                    if (end < 0) {
                        throw new ConfigException("Invalid INI-Format, ']' expected, at " + lineNum + " in " + resource);
                    }
                    section = line.substring(1, end);
                } else if (!line.trim().startsWith("#")) {
                    int sep = line.indexOf(61);
                    String key = line.substring(0, sep);
                    String value = line.substring(sep + 1);
                    if (section != null) {
                        builder.addSectionProperty(section, key, value);
                    } else {
                        builder.addProperty(key, value);
                    }
                }
                line = reader.readLine();
            }
            ConfigurationData configurationData = builder.build();
            return configurationData;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not read configuration: " + resource, e);
            return null;
        }
    }
}

