/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputStreamFactory
implements Closeable {
    private static final Logger LOG = Logger.getLogger(InputStreamFactory.class.getName());
    private byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStreamFactory(InputStream original) throws IOException {
        Objects.requireNonNull(original);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[256];
        try {
            int read = original.read(bytes);
            while (read > 0) {
                bos.write(bytes, 0, read);
                read = original.read(bytes);
            }
            this.data = bos.toByteArray();
        }
        finally {
            try {
                original.close();
            }
            catch (IOException e) {
                LOG.log(Level.FINEST, "Error closing stream: " + original, e);
            }
        }
    }

    public InputStream createInputStream() throws IOException {
        byte[] bytes = this.data;
        if (bytes == null) {
            throw new IOException("InputStreamFactory is closed.");
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public void close() throws IOException {
        this.data = null;
    }
}

