/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormat;
import org.apache.tamaya.format.InputStreamFactory;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ConfigurationFormats {
    private static final Logger LOG = Logger.getLogger(ConfigurationFormats.class.getName());

    private ConfigurationFormats() {
    }

    public static List<ConfigurationFormat> getFormats() {
        return ServiceContextManager.getServiceContext().getServices(ConfigurationFormat.class);
    }

    public static List<ConfigurationFormat> getFormats(String ... formatNames) {
        ArrayList<ConfigurationFormat> result = new ArrayList<ConfigurationFormat>();
        HashSet<String> names = new HashSet<String>(Arrays.asList(formatNames));
        for (ConfigurationFormat f : ConfigurationFormats.getFormats()) {
            if (!names.contains(f.getName())) continue;
            result.add(f);
        }
        return result;
    }

    public static List<ConfigurationFormat> getFormats(URL url) {
        List<ConfigurationFormat> formats = ConfigurationFormats.getFormats();
        ArrayList<ConfigurationFormat> result = new ArrayList<ConfigurationFormat>();
        for (ConfigurationFormat f : formats) {
            if (!f.accepts(url)) continue;
            result.add(f);
        }
        return result;
    }

    public static ConfigurationData readConfigurationData(URL url) throws IOException {
        List<ConfigurationFormat> formats = ConfigurationFormats.getFormats(url);
        return ConfigurationFormats.readConfigurationData(url, formats.toArray(new ConfigurationFormat[formats.size()]));
    }

    public static ConfigurationData readConfigurationData(URL url, ConfigurationFormat ... formats) throws IOException {
        return ConfigurationFormats.readConfigurationData(url.toString(), url.openStream(), formats);
    }

    public static Collection<ConfigurationData> getPropertySources(Collection<URL> urls, ConfigurationFormat ... formats) {
        ArrayList<ConfigurationData> dataRead = new ArrayList<ConfigurationData>();
        for (URL url : urls) {
            try {
                ConfigurationData data = ConfigurationFormats.readConfigurationData(url, formats);
                if (data == null) continue;
                dataRead.add(data);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error reading file: " + url.toExternalForm(), e);
            }
        }
        return dataRead;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigurationData readConfigurationData(String resource, InputStream inputStream, ConfigurationFormat ... formats) throws IOException {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(resource);
        InputStreamFactory isFactory = new InputStreamFactory(inputStream);
        ConfigurationFormat[] configurationFormatArray = formats;
        int n = configurationFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationFormat format = configurationFormatArray[n2];
            try (InputStream is = isFactory.createInputStream();){
                ConfigurationData data = format.readConfiguration(resource, is);
                if (data != null) {
                    ConfigurationData configurationData = data;
                    return configurationData;
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Format " + format.getClass().getName() + " failed to read resource " + resource, e);
            }
            ++n2;
        }
        return null;
    }
}

