/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormat;

public final class ConfigurationDataBuilder {
    ConfigurationFormat format;
    String resource;
    Map<String, String> defaultProperties;
    Map<String, String> combinedProperties;
    Map<String, Map<String, String>> namedSections;

    private ConfigurationDataBuilder(String resource, ConfigurationFormat format) {
        this.format = Objects.requireNonNull(format);
        this.resource = Objects.requireNonNull(resource);
    }

    public static ConfigurationDataBuilder of(String resource, ConfigurationFormat format) {
        return new ConfigurationDataBuilder(resource, format);
    }

    public static ConfigurationDataBuilder of(ConfigurationData data) {
        ConfigurationDataBuilder b = new ConfigurationDataBuilder(data.getResource(), data.getFormat());
        if (data.hasDefaultProperties()) {
            b.getDefaultProperties().putAll(data.getDefaultProperties());
        }
        if (data.hasCombinedProperties()) {
            b.getCombinedProperties().putAll(data.getCombinedProperties());
        }
        if (!data.getSections().isEmpty()) {
            b.getSections().putAll(data.getSections());
        }
        return b;
    }

    public ConfigurationDataBuilder addSections(String ... sections) {
        for (String section : sections) {
            if (this.getSections().containsKey(section)) continue;
            this.getSections().put(section, new HashMap());
        }
        return this;
    }

    public ConfigurationDataBuilder addSectionProperty(String section, String key, String value) {
        Map<String, String> map = this.getSections().get(section);
        if (map == null) {
            map = new HashMap<String, String>();
            this.getSections().put(section, map);
        }
        map.put(key, value);
        return this;
    }

    public ConfigurationDataBuilder addProperty(String key, String value) {
        this.getDefaultProperties().put(key, value);
        return this;
    }

    public ConfigurationDataBuilder addSectionProperties(String section, Map<String, String> properties) {
        Map<String, String> map = this.getSections().get(section);
        if (map == null) {
            map = new HashMap<String, String>();
            this.getSections().put(section, map);
        }
        map.putAll(properties);
        return this;
    }

    public ConfigurationDataBuilder addProperties(Map<String, String> properties) {
        this.getDefaultProperties().putAll(properties);
        return this;
    }

    public ConfigurationDataBuilder setCombinedProperties(Map<String, String> properties) {
        this.combinedProperties = new HashMap<String, String>(properties);
        return this;
    }

    public Map<String, String> getDefaultProperties() {
        if (this.defaultProperties == null) {
            this.defaultProperties = new HashMap<String, String>();
        }
        return this.defaultProperties;
    }

    public Map<String, String> getCombinedProperties() {
        if (this.combinedProperties == null) {
            this.combinedProperties = new HashMap<String, String>();
        }
        return this.combinedProperties;
    }

    public Map<String, Map<String, String>> getSections() {
        if (this.namedSections == null) {
            this.namedSections = new HashMap<String, Map<String, String>>();
        }
        return this.namedSections;
    }

    public ConfigurationData build() {
        return new ConfigurationData(this);
    }

    public String toString() {
        return "ConfigurationDataBuilder{format=" + this.format + ", default properties=" + this.defaultProperties + ", sections=" + this.namedSections + ", combined properties=" + this.combinedProperties + ", resource=" + this.resource + '}';
    }
}

