/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tamaya.format.ConfigurationDataBuilder;
import org.apache.tamaya.format.ConfigurationFormat;

public final class ConfigurationData {
    private Map<String, String> defaultProperties;
    private Map<String, String> combinedProperties;
    private Map<String, Map<String, String>> namedSections;
    private ConfigurationFormat format;
    private String resource;

    ConfigurationData(ConfigurationDataBuilder builder) {
        this.format = builder.format;
        this.resource = builder.resource;
        if (builder.defaultProperties != null) {
            this.defaultProperties = new HashMap<String, String>();
            this.defaultProperties.putAll(builder.defaultProperties);
        }
        if (builder.combinedProperties != null) {
            this.combinedProperties = new HashMap<String, String>();
            this.combinedProperties.putAll(builder.combinedProperties);
        }
        if (builder.namedSections != null) {
            this.namedSections = new HashMap<String, Map<String, String>>();
            this.namedSections.putAll(builder.namedSections);
        }
        if (this.combinedProperties == null || this.combinedProperties.isEmpty()) {
            this.combinedProperties = new HashMap<String, String>();
            this.combinedProperties.putAll(this.getDefaultProperties());
            for (String sectionName : this.getSectionNames()) {
                Map<String, String> section = this.getSection(sectionName);
                for (Map.Entry<String, String> en : section.entrySet()) {
                    String key = sectionName + '.' + en.getKey();
                    this.combinedProperties.put(key, en.getValue());
                }
            }
        }
    }

    public ConfigurationFormat getFormat() {
        return this.format;
    }

    public String getResource() {
        return this.resource;
    }

    public Set<String> getSectionNames() {
        if (this.namedSections == null) {
            return Collections.emptySet();
        }
        return this.namedSections.keySet();
    }

    public Map<String, String> getSection(String name) {
        return this.namedSections.get(name);
    }

    public Map<String, String> getDefaultProperties() {
        if (this.defaultProperties == null) {
            return Collections.emptyMap();
        }
        return this.defaultProperties;
    }

    public Map<String, String> getCombinedProperties() {
        if (this.combinedProperties == null) {
            return Collections.emptyMap();
        }
        return this.combinedProperties;
    }

    public Map<String, Map<String, String>> getSections() {
        if (this.namedSections == null) {
            return Collections.emptyMap();
        }
        return this.namedSections;
    }

    public boolean hasDefaultProperties() {
        return this.defaultProperties != null && !this.defaultProperties.isEmpty();
    }

    public boolean hasCombinedProperties() {
        return this.combinedProperties != null && !this.combinedProperties.isEmpty();
    }

    private boolean hasSections() {
        return this.namedSections != null && !this.namedSections.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasCombinedProperties() && !this.hasDefaultProperties() && !this.hasSections();
    }

    public String toString() {
        return "ConfigurationData{format=" + this.format + ", default properties=" + this.defaultProperties + ", combined properties=" + this.combinedProperties + ", sections=" + this.namedSections + ", resource=" + this.resource + '}';
    }
}

