/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.format;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormat;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;

public abstract class BaseFormatPropertySourceProvider
implements PropertySourceProvider {
    private static final Logger LOG = Logger.getLogger(BaseFormatPropertySourceProvider.class.getName());
    private List<ConfigurationFormat> configFormats = new ArrayList<ConfigurationFormat>();
    private Collection<URL> paths = new ArrayList<URL>();
    private Optional<ClassLoader> classLoader;

    public BaseFormatPropertySourceProvider(List<ConfigurationFormat> formats, URL ... paths) {
        this.configFormats.addAll((Collection<ConfigurationFormat>)Objects.requireNonNull(formats));
        this.paths.addAll(Arrays.asList((Object[])Objects.requireNonNull(paths)));
    }

    public BaseFormatPropertySourceProvider(List<ConfigurationFormat> formats, String ... paths) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        this.configFormats.addAll((Collection<ConfigurationFormat>)Objects.requireNonNull(formats));
        for (String path : paths) {
            Enumeration<URL> urls = null;
            try {
                urls = cl.getResources(path);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to read resource: " + path, e);
                continue;
            }
            while (urls.hasMoreElements()) {
                this.paths.add(urls.nextElement());
            }
        }
    }

    public BaseFormatPropertySourceProvider(List<ConfigurationFormat> formats, ClassLoader classLoader, String ... paths) {
        this.configFormats.addAll((Collection<ConfigurationFormat>)Objects.requireNonNull(formats));
        for (String path : paths) {
            Enumeration<URL> urls = null;
            try {
                urls = classLoader.getResources(path);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to read resource: " + path, e);
                continue;
            }
            while (urls.hasMoreElements()) {
                this.paths.add(urls.nextElement());
            }
        }
    }

    protected abstract Collection<PropertySource> getPropertySources(ConfigurationData var1);

    public Collection<PropertySource> getPropertySources() {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        for (URL res : this.paths) {
            try {
                InputStream is = res.openStream();
                Throwable throwable = null;
                try {
                    for (ConfigurationFormat format : this.configFormats) {
                        ConfigurationData data = format.readConfiguration(res.toString(), is);
                        propertySources.addAll(this.getPropertySources(data));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to put resource based config: " + res, e);
            }
        }
        return propertySources;
    }
}

