/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Map;
import org.apache.tamaya.ConfigException;

public class JSONVisitor {
    private final ObjectNode rootNode;
    private final Map<String, String> targetStore;

    public JSONVisitor(ObjectNode startNode, Map<String, String> target) {
        this.rootNode = startNode;
        this.targetStore = target;
    }

    public void run() {
        ArrayDeque<VisitingContext> stack = new ArrayDeque<VisitingContext>();
        stack.add(new VisitingContext(this.rootNode));
        boolean goOn = ((VisitingContext)stack.peek()).hasNext();
        if (goOn) {
            do {
                String key;
                Map.Entry<String, JsonNode> current;
                if ((current = ((VisitingContext)stack.peek()).nextElement()).getValue() instanceof ValueNode) {
                    key = ((VisitingContext)stack.peek()).getNSPrefix() + current.getKey();
                    String value = current.getValue().asText();
                    this.targetStore.put(key, value);
                } else if (current.getValue() instanceof ObjectNode) {
                    key = ((VisitingContext)stack.peek()).getNSPrefix() + current.getKey();
                    ObjectNode node = (ObjectNode)current.getValue();
                    stack.push(new VisitingContext(node, key));
                } else {
                    if (current.getValue() instanceof ArrayNode) {
                        throw new ConfigException("Arrays are not supported at the moment.");
                    }
                    throw new ConfigException("Internal failure while processing JSON document.");
                }
                goOn = ((VisitingContext)stack.peek()).hasNext();
                while (!goOn && stack.size() > 0) {
                    stack.remove();
                    goOn = stack.size() > 0 && ((VisitingContext)stack.peek()).hasNext();
                }
            } while (goOn);
        }
    }

    private static class VisitingContext {
        private String namespace;
        private final ObjectNode node;
        private final Iterator<Map.Entry<String, JsonNode>> elements;

        public VisitingContext(ObjectNode node) {
            this(node, "");
        }

        public VisitingContext(ObjectNode rootNode, String currentNamespace) {
            this.namespace = currentNamespace;
            this.node = rootNode;
            this.elements = this.node.fields();
        }

        public Map.Entry<String, JsonNode> nextElement() {
            return this.elements.next();
        }

        public boolean hasNext() {
            return this.elements.hasNext();
        }

        public String getNSPrefix() {
            return this.namespace.isEmpty() ? this.namespace : this.namespace + ".";
        }
    }
}

